package org.lsst.ccs.subsystem.refrig.constants;

import org.lsst.ccs.bus.data.Alert;

/**
 * Hex subsystem Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum HexAlert {

    EVAP_TEMP_LOW("EvapExitTempLow", "evaporator exit temp low");
        
    private final String id, description;
    
    HexAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId(String compName) {
        return compName + id;
    }
    
    public String getDescription(String compName) {
        return compName + " " + description;
    }
    
    public Alert newAlert(String compName) {
        return new Alert(getId(compName), getDescription(compName));
    }
    
}
