package org.lsst.ccs.subsystem.refrig.constants;

/**
 *  Formatted tables of chiller errors and warnings
 */

public class ChillerErrorTables {

    private static final String error1Table = "// Error1 Bits" +
"\n 0x00000001    E1_GPIB_RX_OVERFLOW       " +
"\n 0x00000002    E1_FAIL_SAFE_ENGAGED      " +
"\n 0x00000004    E1_RTD1_NO_PROBE_CAL      " +
"\n 0x00000008    E1_LINE_FREQ_NOT_DETECTED " +
"\n 0x00000010    E1_CODE_BASE_CHANGED      " +
"\n 0x00000020    E1_LOW_FLUID              " +
"\n 0x00000040    E1_ANALOG_INPUT           " +
"\n 0x00000080    E1_RTD1                   " +
"\n 0x00000100    E1_RTD2                   " +
"\n 0x00000200    E1_TC                     " +
"\n 0x00000400    E1_CJ                     " +
"\n 0x00000800    E1_FRONT_PANEL_MISSING    " +
"\n 0x00001000    E1_ETH_USB_MISSING        " +
"\n 0x00002000    E1_TRANSLATOR_MISSING     " +
"\n 0x00004000    E1_REMOTE_DIGITAL_TEMP_MISSING  " +
"\n 0x00008000    E1_FACTORY_NVM_NOT_SET    " +
"\n 0x00010000    E1_TEMP_RUN_AWAY          " +
"\n 0x00020000    E1_TC_CAL_BAD             " +
"\n 0x00040000    E1_VFD_FAULT              " +
"\n 0x00080000    E1_HIGH_PRESSURE_FAULT    " +
"\n 0x00100000    E1_CONTROLLER_TEMP_LOW    " +
"\n 0x00200000    E1_CONTROLLER_TEMP_HIGH   " +
"\n 0x00400000    E1_SERIAL_RX_OVERFLOW     " +
"\n 0x00800000    E1_REMOTE_SERIAL_COM      " +
"\n 0x01000000    E1_PROGRAM_ILLEGAL_STEP   " +
"\n 0x02000000    E1_RTD2_NO_PROBE_CAL      " +
"\n 0x04000000    E1_TANK_TOO_FULL          " +
"\n 0x08000000    E1_TCP_RX_OVERFLOW        " +
"\n 0x10000000    E1_NVM_NOT_SAVED_BAD_PARAM" +
"\n 0x20000000    // Future Use             " +
"\n 0x40000000    E1_AD_NO_DATA             " +
"\n 0x80000000    E1_PID_PARAMS_BAD         \n";

    private static final String error2Table = "// Error2 Bits" +
"\n 0x00000001    E2_SERIAL_TX_OVERFLOW     " +
"\n 0x00000002    // Future Use             " +
"\n 0x00000004    E2_LOW_FLOW_RATE_FROM_SWITCH  " +
"\n 0x00000008    // Future Use             " +
"\n 0x00000010    E2_AC_PHASE_FAULT         " +
"\n 0x00000020    E2_EMERGENCY_SWITCH_DETECTED  " +
"\n 0x00000040    // Future Use             " +
"\n 0x00000080    E2_COMPRESSOR1_FAIL       " +
"\n 0x00000100    E2_COMPRESSOR2_FAIL       " +
"\n 0x00000200    // Future Use             " +
"\n 0x00000400    E2_LOW_FLOW_RATE_FROM_METER   " +
"\n 0x00000800    //Future Use              " +
"\n 0x00001000    E2_BAD_EEPROM             " +
"\n ..." +
"\n 0x80000000    E2_CLEAR_ERROR_BITS   //  Special Case \n";

    private static final String warning1Table = "// Warning Bits" +
"\n 0x00000001    W_RESET_FROM_BROWN_OUT            " +
"\n 0x00000002    W_RESET_FROM_WDT                  " +
"\n 0x00000004    W_TOD_BAD                         " +
"\n 0x00000008    W_FIRMWARE_NOT_UPDATED_FROM_VB_APP" +
"\n 0x00000010    W_RAMP_TIMEOUT                    " +
"\n 0x00000020    W_SD_CARD_INIT                    " +
"\n 0x00000040    W_SD_CARD_MISSING                 " +
"\n 0x00000080    W_NVM_SET_TO_DEFAULTS             " +
"\n 0x00000100    W_LOW_N2                          " +
"\n 0x00000200    W_LOW_FLUID                       " +
"\n 0x00000400    W_SD_CARD_WRITE_PROTECTED         " +
"\n 0x00000800    W_SD_CARD_WRITE_ERROR             " +
"\n 0x00001000    W_USB_STICK_MISSING               " +
"\n 0x00002000    W_USB_STICK_WRITE_PROTECTED       " +
"\n 0x00004000    W_USB_STICK_INIT                  " +
"\n 0x00008000    W_USB_STICK_WRITE_ERROR           " +
"\n 0x00010000    W_NOT_RELEASED_FIRMWARE           " +
"\n 0x00020000    W_DRIP_TRAY_FULL                  " +
"\n 0x00040000    W_TOD_NOT_SET_CORRECTLY           " +
"\n 0x00080000    W_USB_STICK_NOT_ENOUGH_MEMORY     " +
"\n 0x00100000    W_SYS_COMM_CHECKSUM               " +
"\n 0x00200000    W_SYS_COMM_OVERRUN                " +
"\n 0x00400000    W_SYS_COMM                        " +
"\n 0x00800000    W_SYS_DATA                        " +
"\n 0x01000000    W_TWO_CONSECUTIVE_WD_RESETS       " +
"\n 0x02000000    W_CONTROLLER_TEMP_HIGH            " +
"\n 0x04000000    W_CONTROLLER_TEMP_LOW             " +
"\n 0x08000000    W_SOFTWARE_REVISIONS_MISMATCHED   " +
"\n 0x10000000    W_REMOTE_SERIAL_COM               " +
"\n 0x20000000    W_LOW_PRESSURE                    " +
"\n 0x40000000    W_USER_NVM_LIFE                   " +
"\n 0x80000000    W_LOW_FLOW_RATE_FROM_SWITCH       \n";

    private static final String warning2Table = "// Warning2 Bits" +
"\n 0x00000001    W2_CANNOT_REACH_TANK_PRESSURE    \n";

    public static String getError1Table() {return error1Table;}
    public static String getError2Table() {return error2Table;}
    public static String getWarning1Table() {return warning1Table;}
    public static String getWarning2Table() {return warning2Table;}
}
