/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nom.tam.fits.FitsException;
import org.lsst.ccs.utilities.image.DateUtils;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class HeaderSpecification {
    private String name;
    private final Map<String, HeaderLine> headers = new LinkedHashMap<String, HeaderLine>();
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{(.*)}");
    private static final Pattern INNER_EXPRESSION_PATTERN = Pattern.compile("(?<pre>.*)(?<exp>(\\$\\{(?<value>[^\\$\\{\\}]*)\\}))(?<post>.*)");
    private static final Pattern SYSTEM_PROPERTY_PATTERN = Pattern.compile(".*(\\[System\\(([^,]+)(,.*)?\\)\\]).*");
    private static final Pattern LINE_PATTERN = Pattern.compile("\\s*(\\S+)\\s+(\\w+)\\s+(?:\"(.*)\"|(\\S+))\\s*(.*)");
    private static final Logger LOG = Logger.getLogger(HeaderSpecification.class.getName());

    public HeaderSpecification(String name, InputStream in) throws IOException {
        this(name, new InputStreamReader(in));
    }

    public HeaderSpecification(String name, Reader in) throws IOException {
        this.name = name;
        this.loadHeaderSpecification(in);
    }

    final void loadHeaderSpecification(InputStream in) throws IOException {
        this.loadHeaderSpecification(new InputStreamReader(in));
    }

    final void loadHeaderSpecification(Reader in) throws IOException {
        String line;
        BufferedReader reader;
        BufferedReader bufferedReader = reader = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#") || line.trim().isEmpty()) continue;
            try {
                Matcher sysPropMatcher;
                while ((sysPropMatcher = SYSTEM_PROPERTY_PATTERN.matcher(line)).matches()) {
                    String def = sysPropMatcher.group(3);
                    def = def == null ? "" : def.substring(1);
                    line = line.replace(sysPropMatcher.group(1), System.getProperty(sysPropMatcher.group(2), def));
                }
                HeaderLine headerLine = new HeaderLine(line);
                if (this.headers.containsKey(headerLine.getKeyword())) {
                    LOG.log(Level.INFO, "Duplicate definition for header keyword: {0}. Overriding current definition {1}.", new Object[]{headerLine.getKeyword(), this.headers.get(headerLine.getKeyword()).getMetaName()});
                }
                this.headers.put(headerLine.getKeyword(), headerLine);
            }
            catch (IOException x) {
                throw new IOException("Error while reading line:\n\t" + line, x);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public HeaderLine getHeader(String keyWord) {
        return this.headers.get(keyWord);
    }

    public Collection<HeaderLine> getHeaders() {
        return Collections.unmodifiableCollection(this.headers.values());
    }

    Collection<HeaderLine> getRequiredHeaders() {
        return this.headers.values().stream().filter(h -> ((HeaderLine)h).isRequired).collect(Collectors.toCollection(ArrayList::new));
    }

    private static Integer sensibleDecode(String valueExpression) {
        if (valueExpression.startsWith("0x")) {
            return Integer.decode(valueExpression);
        }
        return Integer.valueOf(valueExpression);
    }

    private static Object coerce(String valueExpression, DataType dataType) throws FitsException, NumberFormatException {
        switch (dataType) {
            case Integer: {
                return HeaderSpecification.sensibleDecode(valueExpression);
            }
            case Float: {
                return Double.valueOf(valueExpression);
            }
            case Boolean: {
                return Boolean.valueOf(valueExpression);
            }
            case Date: {
                return DateUtils.convertStringToDate(valueExpression);
            }
            case MJD: {
                return Double.valueOf(valueExpression);
            }
        }
        return valueExpression;
    }

    public static void main(String[] argv) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("something/23", "1");
        map.put("else", "2");
        map.put("again", "3");
        String expressionVal = "${something/${else}${again}}";
    }

    public static class HeaderLine {
        private final String keyword;
        private final DataType dataType;
        private final String comment;
        private String metaName;
        private Object value;
        private String metaMap;
        private String valueExpression;
        private final boolean isExpression;
        private boolean evaluateOnTheFly = false;
        private final boolean isRequired;
        private final String originalLine;

        HeaderLine(String line) throws IOException {
            this.originalLine = line;
            try {
                Matcher lineMatcher = LINE_PATTERN.matcher(line);
                if (!lineMatcher.matches()) {
                    throw new IOException("Invalid line in header specification");
                }
                String tmpKeyword = lineMatcher.group(1);
                this.isRequired = tmpKeyword.endsWith("!");
                this.keyword = this.isRequired ? tmpKeyword.substring(0, tmpKeyword.length() - 1) : tmpKeyword;
                this.dataType = DataType.valueOf(lineMatcher.group(2));
                this.valueExpression = lineMatcher.group(3) == null ? lineMatcher.group(4) : lineMatcher.group(3);
                Matcher matcher = EXPRESSION_PATTERN.matcher(this.valueExpression);
                this.isExpression = matcher.matches();
                if (this.isExpression) {
                    String expression = matcher.group(1);
                    Matcher inner_matcher = INNER_EXPRESSION_PATTERN.matcher(this.valueExpression);
                    if (inner_matcher.matches() && !expression.equals(inner_matcher.group("value"))) {
                        this.evaluateOnTheFly = true;
                    }
                    if (!this.evaluateOnTheFly) {
                        String[] split = this.splitKey(expression);
                        this.metaMap = split[0];
                        this.metaName = split[1];
                        this.value = null;
                    }
                } else {
                    this.metaMap = null;
                    this.metaName = null;
                    this.value = HeaderSpecification.coerce(this.valueExpression, this.dataType);
                }
                this.comment = lineMatcher.group(5).trim();
            }
            catch (IllegalArgumentException | FitsException x) {
                throw new IOException("Illegal token found while reading header specification", x);
            }
            FitsHeadersSpecificationsBuilder.log.debug((Object)("HeaderLine " + this.keyword + " " + this.metaMap + " " + this.metaName + " [" + this.originalLine + "]"));
        }

        public String getKeyword() {
            return this.keyword;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public String getMetaName() {
            return this.metaName;
        }

        String getMetaMap() {
            return this.metaMap;
        }

        public String getComment() {
            return this.comment;
        }

        boolean isExpression() {
            return this.isExpression;
        }

        boolean isRequired() {
            return this.isRequired;
        }

        String getHeaderDefinition() {
            return this.originalLine;
        }

        Object getValue(MetaDataSet metaDataSet) {
            if (this.evaluateOnTheFly) {
                Matcher matcher;
                String expressionToBeParsed = this.valueExpression;
                while ((matcher = INNER_EXPRESSION_PATTERN.matcher(expressionToBeParsed)).matches()) {
                    String expressionToReplace = matcher.group("exp");
                    String key = matcher.group("value");
                    boolean done = expressionToReplace.equals(expressionToBeParsed);
                    if (done) {
                        return this.findMetaDataValue(key, metaDataSet, this.dataType);
                    }
                    Object value = this.findMetaDataValue(key, metaDataSet, DataType.String);
                    if (value == null) {
                        throw new RuntimeException("Could not replace value " + key + " [" + expressionToReplace + "]");
                    }
                    expressionToBeParsed = expressionToBeParsed.replace(expressionToReplace, (String)value);
                }
                return this.findMetaDataValue(expressionToBeParsed, metaDataSet, this.dataType);
            }
            if (this.isExpression) {
                return this.findMetaDataValue(this.metaMap, this.metaName, metaDataSet, this.dataType);
            }
            return this.value;
        }

        private String[] splitKey(String key) {
            String[] result = new String[2];
            int dotIndex = key.indexOf(".");
            int slashIndex = key.indexOf("/");
            if (dotIndex == -1 || dotIndex != -1 && slashIndex != -1 && slashIndex < dotIndex) {
                result[0] = null;
                result[1] = key;
            } else {
                result[0] = key.substring(0, dotIndex);
                result[1] = key.substring(dotIndex + 1);
            }
            return result;
        }

        private Object findMetaDataValue(String key, MetaDataSet metaDataSet, DataType type) {
            String[] split = this.splitKey(key);
            String map = split[0];
            String name = split[1];
            return this.findMetaDataValue(map, name, metaDataSet, type);
        }

        private Object findMetaDataValue(String map, String name, MetaDataSet metaDataSet, DataType type) {
            Object obj = metaDataSet.getValue(map, name);
            if (obj instanceof String) {
                try {
                    obj = HeaderSpecification.coerce((String)obj, type);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return obj;
        }
    }

    public static enum DataType {
        Boolean,
        Integer,
        String,
        Float,
        Date,
        MJD;

    }
}

