/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CategoryTag
implements Serializable {
    private final String categoryName;
    private final List<String> tags = new ArrayList<String>();
    private final Map<String, Integer> tagVersions = new HashMap<String, Integer>();
    volatile boolean hasChanges = false;
    public static final String DEFAULT_CONFIG_NAME = "";
    public static final String DEFAULT_INITIAL_CONFIG_NAME = "defaultInitial";
    public static final String DEFAULT_CAT = "";
    public static final String SAFE_CONFIG_NAME = "safe";
    private static final String DEFAULT_V_STRING = "d";
    private static final String LATEST_V_STRING = "l";
    private static final String UNDEF_V_STRING = "u";
    public static final int DEFAULT_VERSION = -1;
    public static final int LATEST_VERSION = -2;
    public static final int UNDEF_VERSION = -3;
    private static final Pattern CATEGORY_TAG_PATTERN = Pattern.compile("((?<category>.*?)[:])?(?<tags>.*?)(?<hasChanged>\\*?)");
    private static final Pattern TAG_PATTERN = Pattern.compile("(?<tag>.*?)([(]{1}?((?<version>[0-9]*|l|d|u))[)]{1})?");

    public CategoryTag(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public boolean containsTag(String tag) {
        return this.tags.contains(tag);
    }

    public Integer getTagVersion(String tag) {
        if (!this.containsTag(tag)) {
            throw new IllegalArgumentException("Tag \"" + tag + "\" does not exist for this CategoryTag");
        }
        return this.tagVersions.get(tag);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCategoryName()).append(":");
        int nTags = this.getNumberOfTags();
        for (String tag : this.getTags()) {
            sb.append(tag).append("(").append(this.getTagVersionAsString(tag)).append(")");
            if (--nTags <= 0) continue;
            sb.append("|");
        }
        if (this.hasChanges) {
            sb.append("*");
        }
        return sb.toString();
    }

    public void setHasChanges(boolean hasChanges) {
        this.hasChanges = hasChanges;
    }

    private String getTagVersionAsString(String tag) {
        if (!this.containsTag(tag)) {
            throw new IllegalArgumentException("Tag \"" + tag + "\" does not exist for this CategoryTag");
        }
        Integer ver = this.tagVersions.get(tag);
        if (ver == null) {
            return UNDEF_V_STRING;
        }
        switch (ver) {
            case -3: {
                return UNDEF_V_STRING;
            }
            case -2: {
                return LATEST_V_STRING;
            }
            case -1: {
                return DEFAULT_V_STRING;
            }
        }
        return String.valueOf(ver);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void addOrUpdateTagVersion(String tag, Integer version) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
        this.tagVersions.put(tag, version);
    }

    private void addTagVersion(String tag, Integer version) {
        if (this.tags.contains(tag)) {
            throw new RuntimeException("Tag: " + tag + " already exists for this CategoryTag");
        }
        this.addOrUpdateTagVersion(tag, version);
    }

    int getNumberOfTags() {
        return this.tags.size();
    }

    public CategoryTag merge(CategoryTag categoryTag) {
        for (String tag : categoryTag.getTags()) {
            this.addOrUpdateTagVersion(tag, categoryTag.getTagVersion(tag));
        }
        return this;
    }

    public static final CategoryTag parseCategoryTagInput(String categoryTagInput) {
        Matcher m = CATEGORY_TAG_PATTERN.matcher(categoryTagInput);
        if (m.matches()) {
            String[] stringArray;
            String cat = m.group("category");
            if (cat == null) {
                cat = "";
            }
            CategoryTag categoryTag = new CategoryTag(cat);
            String allTags = m.group("tags");
            if (allTags == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            } else {
                stringArray = allTags.split("\\|");
            }
            String[] tags = stringArray;
            boolean hasChanged = "*".equals(m.group("hasChanged"));
            categoryTag.setHasChanges(hasChanged);
            for (String t : tags) {
                String tag;
                Matcher tagMatcher = TAG_PATTERN.matcher(t);
                if (tagMatcher.matches()) {
                    tag = tagMatcher.group("tag");
                    if (tag == null) {
                        tag = "";
                    }
                } else {
                    throw new IllegalArgumentException("Could not match tag: " + t);
                }
                String v = tagMatcher.group("version");
                int ver = v == null || v.isEmpty() || v.equals(DEFAULT_V_STRING) ? -1 : (v.equals(LATEST_V_STRING) ? -2 : (v.equals(UNDEF_V_STRING) ? -3 : Integer.valueOf(v)));
                categoryTag.addTagVersion(tag, ver);
            }
            return categoryTag;
        }
        throw new IllegalArgumentException("Could not parse a CategoryTag from input string: \"" + categoryTagInput + "\"");
    }
}

