/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;
import org.lsst.ccs.drivers.reb.ImageMetadata;
import org.lsst.ccs.drivers.reb.sim.ClientFactorySimulation;
import org.lsst.ccs.drivers.reb.sim.DataProvider;

public class TestClientFactorySimulator
extends ClientFactorySimulation {
    public static final TestSegmentDataProvider dataProvider = new TestSegmentDataProvider();
    public static final Random r = new Random();

    protected DataProvider createDataProvider() {
        return dataProvider;
    }

    public static class TestSegmentDataProvider
    implements DataProvider {
        private final SegmentDataGenerator dataGenerator = new SegmentDataGenerator();
        private ByteBuffer generatdData;

        public ByteBuffer getGeneratedData() {
            return this.generatdData;
        }

        public ByteBuffer getData(ImageMetadata metadata) {
            this.generatdData = ByteBuffer.allocate(metadata.getLength());
            this.generatdData.order(ByteOrder.nativeOrder());
            while (this.generatdData.hasRemaining()) {
                this.generatdData.putInt(r.nextInt());
            }
            this.generatdData.flip();
            return this.generatdData;
        }

        private class SegmentDataGenerator {
            private int counter = 0;

            private SegmentDataGenerator() {
            }

            int nextInt() {
                ++this.counter;
                if (this.counter == 49) {
                    this.counter = 1;
                }
                return this.counter;
            }
        }
    }
}

