/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;
import org.lsst.ccs.drivers.reb.sim.AddressSpace;
import org.lsst.ccs.drivers.reb.sim.HandleAndIdManager;

public class RegClientDaq1Simulation
implements RegClient.Impl {
    private final HandleAndIdManager manager;

    RegClientDaq1Simulation(HandleAndIdManager manager) {
        this.manager = manager;
    }

    @Override
    public long newRegClient(int id, String ifc) {
        AddressSpace rs = this.manager.getAddressSpaceForId(id);
        return this.manager.allocateHandle(rs);
    }

    @Override
    public void deleteRegClient(long handle) {
        this.manager.freeHandle(handle);
    }

    @Override
    public synchronized int readReg(long handle, int address) throws REBException {
        int[] values = new int[1];
        this.readRegs1(handle, address, values, 0, 1);
        return values[0];
    }

    @Override
    public synchronized void readRegs(long handle, int address, int[] values, int offset, int count) throws REBException {
        this.readRegs1(handle, address, values, offset, count);
    }

    private void readRegs1(long handle, int address, int[] values, int offset, int count) throws REBException {
        AddressSpace rs = this.manager.getAddressSpaceForHandle(handle);
        rs.readRegs(address, values, offset, count);
    }

    @Override
    public synchronized void writeReg(long handle, int address, int value) throws REBException {
        int[] values = new int[]{value};
        this.writeRegs1(handle, address, values, 0, 1);
    }

    @Override
    public synchronized void writeRegs(long handle, int address, int[] values, int offset, int count) throws REBException {
        this.writeRegs1(handle, address, values, offset, count);
    }

    private void writeRegs1(long handle, int address, int[] values, int offset, int count) throws REBException {
        AddressSpace rs = this.manager.getAddressSpaceForHandle(handle);
        rs.writeRegs(address, values, offset, count);
    }

    @Override
    public synchronized int updateReg(long handle, int address, int mask, int value) throws REBException {
        int[] values = new int[]{0};
        this.readRegs1(handle, address, values, 0, 1);
        int oldVal = values[0];
        values[0] = values[0] & ~mask | value & mask;
        this.writeRegs1(handle, address, values, 0, 1);
        return oldVal;
    }
}

