/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.reb.GlobalClient;
import org.lsst.ccs.drivers.reb.REBException;

public class TestGlobal {
    private final GlobalClient gbl = new GlobalClient();

    @Command(name="connect", description="Connect to a partition")
    public void connect(@Argument(description="Partition name") String part) throws REBException {
        this.gbl.open(part);
    }

    @Command(name="connect", description="Connect to a REB")
    public void connect(@Argument(description="Hardware type") HdwType type, @Argument(description="REB ID") int id, @Argument(description="Network interface name") String ifcName) throws REBException {
        this.gbl.open(type.getValue(), new int[]{id}, new String[]{ifcName});
    }

    @Command(name="disconnect", description="Disconnect from a partition/REB")
    public void disconnect() throws REBException {
        this.gbl.close();
    }

    @Command(name="acquire", description="Acquire an image")
    public void trigger(@Argument(description="Image name") String name) throws REBException {
        this.showTime(this.gbl.acquireImage(name));
    }

    @Command(name="acquire", description="Acquire an image")
    public void trigger(@Argument(description="Image name") String name, @Argument(description="Folder name") String folder, @Argument(description="Sequencer opcode") int opcode, @Argument(description="Annotation") String annotation, int ... omittedIds) throws REBException {
        this.showTime(this.gbl.acquireImage(name, folder, opcode, annotation, omittedIds));
    }

    @Command(name="sequence", description="Start the sequrncers")
    public void sequence(@Argument(description="Sequencer opcode") int opcode) throws REBException {
        this.showTime(this.gbl.startSequencer(opcode));
    }

    private void showTime(long time) {
        System.out.format("Time = %tY-%<tm-%<td %<tH:%<tM:%<tS\n", time / 1000000L);
    }

    public static enum HdwType {
        DAQ(6),
        DAQ0(0),
        DAQ1(1),
        DAQ2(2),
        DAQ4(5),
        PCI0(3),
        PCI1(4);

        int value;

        private HdwType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

