/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.pluto;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.pluto.Pluto;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class PlutoDevice
extends Device {
    private static final int TYPE_GLOBAL = 0;
    private static final int TYPE_ADD_BIT = 1;
    private static final int TYPE_ADD_REG = 2;
    private static final int TYPE_ADD_INT = 3;
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    @ConfigurationParameter(category="Device", isFinal=true)
    protected String node;
    protected List<Integer> areas;
    private static final Logger LOG;
    protected Pluto plu;
    private final boolean configAreas;
    private int nArea;
    private final int[] globData = new int[32];
    private final int[] addData = new int[32];
    private final Set<Integer> modsUsed = new HashSet<Integer>();
    private final Set<Integer> areasUsed = new HashSet<Integer>();

    public PlutoDevice() {
        this.configAreas = true;
    }

    public PlutoDevice(int nArea) {
        this.nArea = nArea;
        this.configAreas = nArea < 0;
    }

    protected void initDevice() {
        super.configure(this.mon);
        if (this.node == null) {
            ErrorUtils.reportConfigError(LOG, this.getName(), "node", "is missing");
        }
        if (this.configAreas) {
            if (this.areas == null) {
                ErrorUtils.reportConfigError(LOG, this.getName(), "areas", "is missing");
            }
            if ((this.areas.size() & 1) != 0) {
                ErrorUtils.reportConfigError(LOG, this.getName(), "areas", "has odd number of elements");
            }
            this.nArea = this.areas.size() / 2;
        }
        this.fullName = "Pluto PLC system (" + this.node + ")";
    }

    protected void initialize() {
        try {
            if (!this.inited || this.plu == null) {
                this.plu = new Pluto();
            }
            this.plu.open(this.node);
            if (this.configAreas) {
                this.plu.configStart(-1, 15, 0, 100);
                for (int j = 0; j < this.areas.size(); j += 2) {
                    this.plu.configDataArea(j / 2, this.areas.get(j).intValue(), this.areas.get(j + 1).intValue());
                }
                this.plu.configWrite();
            }
            this.setOnline(true);
            this.initSensors();
            this.setOutputLines();
            LOG.log(Level.INFO, "Connected to {0}", this.fullName);
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
            }
            if (this.plu != null) {
                this.close();
            }
        }
        finally {
            this.inited = true;
        }
    }

    protected void close() {
        try {
            this.plu.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        int id;
        Integer iType = null;
        String[] typeFields = type.split(":", -1);
        if (typeFields.length == 2) {
            iType = typeMap.get(typeFields[0].toUpperCase());
        }
        try {
            id = Integer.decode(typeFields[1]);
        }
        catch (NumberFormatException e) {
            id = -1;
        }
        int maxId = 0;
        if (iType != null) {
            int maxChan;
            int n = maxId = iType == 0 ? 32 : this.nArea;
            int n2 = iType == 0 ? 32 : (iType == 1 ? 16 : (maxChan = iType == 2 ? 2 : 1));
            if (hwChan < 0 || hwChan >= maxChan) {
                ErrorUtils.reportChannelError(LOG, name, "hwchan", hwChan);
            }
        }
        if (iType == null || id < 0 || id >= maxId) {
            ErrorUtils.reportChannelError(LOG, name, "type", type);
        }
        Set<Integer> used = iType == 0 ? this.modsUsed : this.areasUsed;
        used.add(id);
        return new int[]{iType << 8 | id, 0};
    }

    protected void readChannelGroup() {
        if (!this.online) {
            return;
        }
        try {
            for (int id : this.modsUsed) {
                this.globData[id] = this.plu.readGlobalData(id);
            }
            for (int id : this.areasUsed) {
                this.addData[id] = this.plu.readAdditionalData(id);
            }
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error reading {0}: {1}", new Object[]{this.fullName, e});
            this.setOnline(false);
        }
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if (this.online) {
            int index = type & 0xFF;
            switch (type >> 8) {
                case 0: {
                    value = this.globData[index] >> hwChan & 1;
                    break;
                }
                case 1: {
                    value = this.addData[index] >> hwChan & 1;
                    break;
                }
                case 2: {
                    value = this.addData[index] << 16 * (1 - hwChan) >> 16;
                    break;
                }
                case 3: {
                    value = this.addData[index];
                }
            }
        }
        return value;
    }

    protected void checkHwLine(String name, int line) throws Exception {
        if (line < 0 || line >= 64) {
            ErrorUtils.reportChannelError(LOG, name, "line", line);
        }
        this.addLine(line);
    }

    protected void setHwLine(int line, boolean on) {
        this.writeBit(line / 16, line & 0xF, on ? 1 : 0);
    }

    protected Boolean isHwLineSet(int line) {
        return this.readBit(line / 16, line & 0xF) != 0;
    }

    public Boolean isPLCActive() {
        try {
            return this.plu.readModuleStatus() != 0;
        }
        catch (DriverException e) {
            return null;
        }
    }

    public void toggleBit(int area, int bit) {
        this.writeBit(area, bit, 1);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.writeBit(area, bit, 0);
    }

    public void writeBit(int area, int bit, int value) {
        try {
            this.plu.writeAreaBit(area, bit, value);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error writing to {0}: {1}", new Object[]{this.fullName, e});
            this.setOnline(false);
        }
    }

    public Integer readBit(int area, int bit) {
        try {
            return this.plu.readAreaBit(area, bit);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error reading from {0}: {1}", new Object[]{this.fullName, e});
            this.setOnline(false);
            return null;
        }
    }

    public Integer readAddBit(int area, int bit) {
        if (!this.online) {
            return null;
        }
        try {
            return this.plu.readAdditionalData(area) >> bit & 1;
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error reading from {0}: {1}", new Object[]{this.fullName, e});
            this.setOnline(false);
            return null;
        }
    }

    public Integer readAddWord(int area, int word) {
        if (!this.online) {
            return null;
        }
        try {
            int value = this.plu.readAdditionalData(area);
            return word == 0 ? (short)value : (short)(value >> 16);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error reading from {0}: {1}", new Object[]{this.fullName, e});
            this.setOnline(false);
            return null;
        }
    }

    public Integer readAddInt(int area) {
        if (!this.online) {
            return null;
        }
        try {
            return this.plu.readAdditionalData(area);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error reading from {0}: {1}", new Object[]{this.fullName, e});
            this.setOnline(false);
            return null;
        }
    }

    public void writeRegister(int area, int reg, int value) {
        try {
            this.plu.writeAreaRegister(area, reg, value);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error writing to {0}: {1}", new Object[]{this.fullName, e});
            this.setOnline(false);
        }
    }

    static {
        typeMap.put("GLOBAL", 0);
        typeMap.put("ADDBIT", 1);
        typeMap.put("ADDREG", 2);
        typeMap.put("ADDINT", 3);
        LOG = Logger.getLogger(PlutoDevice.class.getName());
    }
}

