/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.config.ConfigurationWriterProvider;
import org.lsst.ccs.config.LocalConfigurationDAO;
import org.lsst.ccs.framework.TreeWalkerUtils;

public class SafeConfigurationPropertiesFileWriter {
    private String description;
    private boolean overwrite;
    static ConfigurationWriterProvider configurationWriterProvider;

    public SafeConfigurationPropertiesFileWriter(String[] args) {
        this.parseArgsCLI(args);
    }

    public static void main(String[] args) throws Exception {
        SafeConfigurationPropertiesFileWriter exec = new SafeConfigurationPropertiesFileWriter(args);
        Subsystem subsystem = BootUtils.getSubsystemFromFile(exec.description);
        ConfigurationHandlerSet chs = new ConfigurationHandlerSet();
        TreeWalkerUtils.proceduralNodeWalk(subsystem.getComponentLookup(), null, n -> chs.addConfigurationHandlerForObject(n.getKey(), n.getPath(), n.getComponent()), null);
        List parameters = chs.initialize(exec.description).getAllParameterInfo();
        HashMap<String, PrintWriter> writerMap = new HashMap<String, PrintWriter>();
        TreeSet orderedParms = new TreeSet(LocalConfigurationDAO.configurationParameterComparator);
        orderedParms.addAll(parameters);
        configurationWriterProvider = new ConfigurationWriterProvider(subsystem.getName());
        if (!exec.overwrite) {
            for (String category : chs.getCategorySet()) {
                if (configurationWriterProvider.getConfigurationProperties("safe", category) == null) continue;
                throw new RuntimeException("Properties file already exists for category " + category);
            }
        }
        for (ConfigurationParameterInfo parmInfo : orderedParms) {
            if (!parmInfo.isFinal()) continue;
            String category = parmInfo.getCategoryName();
            PrintWriter writer = (PrintWriter)writerMap.get(category);
            if (writer == null) {
                writer = configurationWriterProvider.getConfigurationWriter("safe", category);
                writerMap.put(category, writer);
            }
            writer.println(LocalConfigurationDAO.toPropertyString((ConfigurationParameterInfo)parmInfo));
        }
        for (PrintWriter pw : writerMap.values()) {
            pw.flush();
            pw.close();
        }
    }

    private void parseArgsCLI(String[] args) {
        Options commandLineOptions = new Options();
        commandLineOptions.addOption("h", "help", false, "Print the help message");
        commandLineOptions.addOption("v", "verbose", false, "Turns on verbose statements");
        commandLineOptions.addOption("d", "description", true, "Name of Subsystem description file.");
        commandLineOptions.addOption("o", "overwrite", false, "Overwrite existing safe configurations");
        commandLineOptions.getOption("description").setArgName("DESCRIPTION_FILE");
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(commandLineOptions, args, false);
            if (line.hasOption("help")) {
                SafeConfigurationPropertiesFileWriter.usageCLI(commandLineOptions);
            } else {
                this.description = line.getOptionValue("description");
                if (this.description == null) {
                    SafeConfigurationPropertiesFileWriter.usageCLI(commandLineOptions);
                }
                this.overwrite = line.hasOption("overwrite");
            }
        }
        catch (Exception e) {
            SafeConfigurationPropertiesFileWriter.usageCLI(commandLineOptions);
        }
    }

    static void usageCLI(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "WriteSafeConfiguration", "", options, "", true);
        System.exit(0);
    }
}

