/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending.timeselection;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import org.freehep.application.studio.Studio;
import org.freehep.jas.services.PlotPage;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.TrendPlotter;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.PresetList;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.PresetsDialog;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindowDialog;

public final class TimeWindowSelector
extends JComboBox {
    private final String CUSTOM_BUTTON = "Choose...";
    private final String PRESETS_BUTTON = "From Saved...";
    private final String PLOT_BUTTON = "From Plot";
    private final String DEFAULT_NAME = "custom";
    private final int MAX_PRESETS = 10;
    private final PresetList timeWindowList;
    private volatile TimeWindow selection;
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();

    public TimeWindowSelector(Studio application) {
        this.timeWindowList = new PresetList(application);
        this.setRenderer(new Renderer(this.getRenderer()));
        this.setMaximumRowCount(17);
        Model model = new Model(this.timeWindowList);
        this.setModel(model);
        this.setSelectedIndex(1);
        this.selection = model.getSelectedItem();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeWindow ts = TimeWindowSelector.this.myModel().getSelectedItem();
                switch (ts.getName()) {
                    case "Choose...": {
                        ts = TimeWindowDialog.defineTimeWindow(TimeWindowSelector.this, TimeWindowSelector.this.selection);
                        TimeWindowSelector.this.setSelectedTimeWindow(ts);
                        break;
                    }
                    case "From Saved...": {
                        ts = PresetsDialog.managePresets(TimeWindowSelector.this, TimeWindowSelector.this.timeWindowList);
                        if (ts == null) {
                            ts = TimeWindowSelector.this.selection;
                        }
                        ts.touch();
                        Model model = new Model(TimeWindowSelector.this.timeWindowList);
                        int index = model.getIndexOf(ts);
                        if (index == -1) {
                            index = 1;
                        }
                        TimeWindowSelector.this.setSelection((TimeWindow)model.getElementAt(index));
                        model.setSelectedItem(TimeWindowSelector.this.selection);
                        TimeWindowSelector.this.setModel(model);
                        break;
                    }
                    case "From Plot": {
                        try {
                            PlotPage page = LsstTrendingPlugin.getSelectedPage();
                            TrendPlotter plot = (TrendPlotter)page.currentRegion().currentPlot();
                            ts = plot.getTimeWindow();
                            TimeWindowSelector.this.setSelectedTimeWindow(ts);
                        }
                        catch (Exception x) {
                            Console.getConsole().error("There is no currently selected plot.");
                            TimeWindowSelector.this.setSelectedItem(TimeWindowSelector.this.selection);
                        }
                        break;
                    }
                    default: {
                        if (!"custom".equals(ts.getName())) {
                            ts.touch();
                            if ("custom".equals(TimeWindowSelector.this.selection.getName())) {
                                TimeWindowSelector.this.myModel().removeElementAt(4);
                            }
                        }
                        TimeWindowSelector.this.setSelection(ts);
                    }
                }
            }
        });
    }

    public TimeWindow getSelectedTimeWindow() {
        return this.selection;
    }

    public void setSelectedTimeWindow(TimeWindow timeWindow) {
        if (timeWindow == null) {
            this.setSelectedItem(this.selection == null ? TimeWindow.LAST_HOUR : this.selection);
        } else {
            if ((timeWindow = this.timeWindowList.insert(timeWindow)).getName().isEmpty()) {
                timeWindow.setName("custom");
                if ("custom".equals(((TimeWindow)this.myModel().getElementAt(4)).getName())) {
                    this.myModel().removeElementAt(4);
                }
                this.myModel().insertElementAt(timeWindow, 4);
                this.setSelectedIndex(4);
            } else {
                Model model = new Model(this.timeWindowList);
                model.setSelectedItem(timeWindow);
                this.setModel(model);
            }
            this.setSelection(timeWindow);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    private void setSelection(TimeWindow timeWindow) {
        if (!Objects.equals(this.selection, timeWindow)) {
            this.selection = timeWindow;
            Event event = new Event(this, this.selection);
            this.listeners.forEach(listener -> listener.timeWindowChanged(event));
        }
    }

    private Model myModel() {
        return (Model)super.getModel();
    }

    private class Renderer
    implements ListCellRenderer {
        private final ListCellRenderer horse;
        private final JPanel separatorPanel = new JPanel(new BorderLayout());
        private final JSeparator separator = new JSeparator();

        Renderer(ListCellRenderer renderer) {
            this.horse = renderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = this.horse.getListCellRendererComponent(list, ((TimeWindow)value).getName(), index, isSelected, cellHasFocus);
            if (index == 0 || index == 3 || index == TimeWindowSelector.this.getItemCount() - 3) {
                this.separatorPanel.removeAll();
                this.separatorPanel.add(comp, "Center");
                this.separatorPanel.add((Component)this.separator, "South");
                comp = this.separatorPanel;
            }
            return comp;
        }
    }

    private class Model
    extends DefaultComboBoxModel<TimeWindow> {
        Model(PresetList tsList) {
            this.addElement(new TimeWindow("Choose..."));
            TimeWindow selectedItem = TimeWindow.LAST_HOUR;
            this.addElement(TimeWindow.LAST_HOUR);
            this.addElement(TimeWindow.LAST_6_HOURS);
            this.addElement(TimeWindow.LAST_24_HOURS);
            List<TimeWindow> customRanges = tsList.getRecent(10);
            for (TimeWindow ts : customRanges) {
                this.addElement(ts);
            }
            this.addElement(new TimeWindow("From Plot", "now-3600", "now", false));
            this.addElement(new TimeWindow("From Saved..."));
            this.setSelectedItem(selectedItem);
        }

        @Override
        public TimeWindow getSelectedItem() {
            return (TimeWindow)super.getSelectedItem();
        }
    }

    public static class Event
    extends EventObject {
        private final TimeWindow timeWindow;

        public Event(Object source, TimeWindow timeWindow) {
            super(source);
            this.timeWindow = timeWindow;
        }

        public TimeWindow getTimeWindow() {
            return this.timeWindow;
        }
    }

    public static interface Listener {
        public void timeWindowChanged(Event var1);
    }
}

