/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.fpga.xml;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Channel;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Visitable;

@XmlType
public class Timeslice
implements Visitable,
Serializable {
    private static final long serialVersionUID = -2695020529101043198L;
    private String requestedDuration;
    private String value;
    private int index;
    private BigDecimal startNanos;
    private BigDecimal requestedDurationNanos;
    private BigDecimal actualDurationNanos;
    private int clockCycles;
    private final Set<Channel> upChannels = new LinkedHashSet<Channel>();
    private int clockCyclesForCompiler;

    public Timeslice() {
    }

    public Timeslice(String duration, String value) {
        this.requestedDuration = duration;
        this.value = value;
    }

    @XmlElement(name="duration")
    public String getDuration() {
        return this.requestedDuration;
    }

    public void setDuration(String duration) {
        this.requestedDuration = duration;
    }

    @XmlElement(name="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @XmlTransient
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @XmlTransient
    public BigDecimal getStartNanos() {
        return this.startNanos;
    }

    public void setStartNanos(BigDecimal startNanos) {
        this.startNanos = startNanos;
    }

    @XmlTransient
    public BigDecimal getDurationNanos() {
        return this.requestedDurationNanos;
    }

    public void setDurationNanos(BigDecimal durationNanos) {
        this.requestedDurationNanos = durationNanos;
    }

    @XmlTransient
    public BigDecimal getActualDurationNanos() {
        return this.actualDurationNanos;
    }

    public void setActualDurationNanos(BigDecimal actualDurationNanos) {
        this.actualDurationNanos = actualDurationNanos;
    }

    @XmlTransient
    public int getClockCycles() {
        return this.clockCycles;
    }

    public Set<Channel> getUpChannels() {
        return this.upChannels;
    }

    public void addUpChannel(Channel c) {
        this.upChannels.add(c);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public int computeClockCycles(BigDecimal clockPeriod, boolean isLast, boolean isDefault) {
        this.clockCycles = this.requestedDurationNanos.divide(clockPeriod).setScale(0, RoundingMode.CEILING).intValue();
        this.clockCyclesForCompiler = isLast ? this.clockCycles - 2 : (this.index == 0 && !isDefault ? this.clockCycles - 1 : this.clockCycles);
        return this.clockCycles;
    }

    @XmlTransient
    public int getClockCyclesForCompiler() {
        return this.clockCyclesForCompiler;
    }
}

