/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.hub;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.RegInfo;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.hub.HubService;
import org.astrogrid.samp.hub.ProfileToken;
import org.astrogrid.samp.hub.WrapperHubConnection;

public class FacadeHubService
implements HubService {
    private final ClientProfile profile_;
    private final Map connectionMap_;
    private static final Logger logger_ = Logger.getLogger(FacadeHubService.class.getName());

    public FacadeHubService(ClientProfile profile) {
        this.profile_ = profile;
        this.connectionMap_ = Collections.synchronizedMap(new HashMap());
    }

    public boolean isHubRunning() {
        return this.profile_.isHubRunning();
    }

    public HubConnection register(ProfileToken profileToken) throws SampException {
        HubConnection baseConnection = this.profile_.register();
        if (baseConnection != null) {
            FacadeHubConnection conn = new FacadeHubConnection(baseConnection){
                final HubConnection hubConn;
                {
                    this.hubConn = this;
                }

                public void ping() throws SampException {
                    if (!FacadeHubService.this.isHubRunning()) {
                        throw new SampException("Hub underlying facade is not running");
                    }
                    super.ping();
                }

                public void unregister() throws SampException {
                    FacadeHubService.this.connectionMap_.keySet().remove(this.hubConn);
                    super.unregister();
                }
            };
            this.connectionMap_.put(conn, profileToken);
            return conn;
        }
        return null;
    }

    public void disconnectAll(ProfileToken profileToken) {
        int ic;
        Map.Entry[] entries = this.connectionMap_.entrySet().toArray(new Map.Entry[0]);
        ArrayList ejectList = new ArrayList();
        for (int ie = 0; ie < entries.length; ++ie) {
            if (!profileToken.equals(entries[ie].getValue())) continue;
            ejectList.add(entries[ie].getKey());
        }
        FacadeHubConnection[] ejectConns = ejectList.toArray(new FacadeHubConnection[0]);
        int nc = ejectConns.length;
        Message discoMsg = new Message("samp.hub.event.shutdown");
        String[] ejectIds = new String[nc];
        for (ic = 0; ic < nc; ++ic) {
            FacadeHubConnection conn = ejectConns[ic];
            ejectIds[ic] = conn.getRegInfo().getSelfId();
            conn.hubEvent(discoMsg);
            this.connectionMap_.remove(conn);
        }
        for (ic = 0; ic < nc; ++ic) {
            this.hubEvent(new Message("samp.hub.event.unregister").addParam("id", ejectIds[ic]));
        }
    }

    public void start() {
    }

    public void shutdown() {
        this.hubEvent(new Message("samp.hub.event.shutdown"));
        this.connectionMap_.clear();
    }

    private void hubEvent(Message msg) {
        String mtype = msg.getMType();
        FacadeHubConnection[] connections = this.connectionMap_.keySet().toArray(new FacadeHubConnection[0]);
        for (int ic = 0; ic < connections.length; ++ic) {
            connections[ic].hubEvent(msg);
        }
    }

    private static class FacadeHubConnection
    extends WrapperHubConnection {
        private CallableClient callable_;
        private Subscriptions subs_;

        FacadeHubConnection(HubConnection base) {
            super(base);
        }

        public void setCallable(CallableClient callable) throws SampException {
            super.setCallable(callable);
            this.callable_ = callable;
        }

        public void declareSubscriptions(Map subs) throws SampException {
            super.declareSubscriptions(subs);
            this.subs_ = subs == null ? null : Subscriptions.asSubscriptions(subs);
        }

        void hubEvent(Message msg) {
            String mtype = msg.getMType();
            CallableClient callable = this.callable_;
            if (callable != null && this.subs_.isSubscribed(mtype)) {
                RegInfo regInfo = this.getRegInfo();
                try {
                    callable.receiveNotification(regInfo.getHubId(), msg);
                }
                catch (Throwable e) {
                    logger_.info("Failed " + mtype + " notification to " + regInfo.getSelfId());
                }
            }
        }
    }
}

