/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending.timeselection;

import java.awt.Dimension;
import java.awt.Window;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.EventObject;
import javafx.application.Platform;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.JDurationChooser;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.JTimeDateChooser;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;

public class TimeWindowDialog
extends JPanel {
    private final int VSPACE = 5;
    private final int HSPACE = 10;
    private final String relTip = "Moment defined relative to now, recalculated every time a plot is refreshed";
    private final String fixedTip = "Fixed moment";
    private final JPanel startPanel;
    private final JPanel endPanel;
    private final JPanel durationPanel;
    private final JLabel agoLabel;
    private final JTimeDateChooser startChooser;
    private final JTimeDateChooser endChooser;
    private final JDurationChooser startDuraChooser;
    private final JDurationChooser durationChooser;
    private final ButtonGroup startGroup;
    private final ButtonGroup endGroup;
    private final JRadioButton startFixedButton;
    private final JRadioButton endFixedButton;
    private final JRadioButton startRelButton;
    private final JRadioButton endRelButton;
    private final JTextField nameField;
    private final JCheckBox saveCheck;
    private static TimeWindow range;
    private static JButton okButton;
    private final Object[] lastChoosers = new Object[2];

    private TimeWindowDialog() {
        this.setLayout(new BoxLayout(this, 1));
        this.startPanel = new JPanel();
        this.startPanel.setLayout(new BoxLayout(this.startPanel, 1));
        this.startPanel.setAlignmentX(0.0f);
        this.startPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Starts "), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        Box box = Box.createHorizontalBox();
        this.startGroup = new ButtonGroup();
        this.startFixedButton = new JRadioButton("Fixed: ");
        this.startFixedButton.setToolTipText("Fixed moment");
        this.startGroup.add(this.startFixedButton);
        box.add(this.startFixedButton);
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        this.startChooser = JTimeDateChooser.getInstance();
        box.add(this.startChooser);
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        box.add(Box.createHorizontalGlue());
        this.startPanel.add(box);
        this.startPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        box = Box.createHorizontalBox();
        this.add(box);
        this.startRelButton = new JRadioButton("Relative: ");
        this.startRelButton.setToolTipText("Moment defined relative to now, recalculated every time a plot is refreshed");
        this.startGroup.add(this.startRelButton);
        box.add(this.startRelButton);
        this.startDuraChooser = new JDurationChooser();
        box.add(this.startDuraChooser);
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        this.agoLabel = new JLabel("ago.");
        box.add(this.agoLabel);
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        box.add(Box.createHorizontalGlue());
        this.startPanel.add(box);
        this.startPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(this.startPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.endPanel = new JPanel();
        this.endPanel.setLayout(new BoxLayout(this.endPanel, 1));
        this.endPanel.setAlignmentX(0.0f);
        this.endPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Ends "), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        box = Box.createHorizontalBox();
        this.endGroup = new ButtonGroup();
        this.endFixedButton = new JRadioButton("Fixed: ");
        this.endFixedButton.setToolTipText("Fixed moment");
        this.endGroup.add(this.endFixedButton);
        box.add(this.endFixedButton);
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        this.endChooser = JTimeDateChooser.getInstance();
        box.add(this.endChooser);
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        box.add(Box.createHorizontalGlue());
        this.endPanel.add(box);
        this.endPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        box = Box.createHorizontalBox();
        this.add(box);
        this.endRelButton = new JRadioButton("Relative:  Now");
        this.endRelButton.setToolTipText("Moment defined relative to now, recalculated every time a plot is refreshed");
        this.endGroup.add(this.endRelButton);
        box.add(this.endRelButton);
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        box.add(Box.createHorizontalGlue());
        this.endPanel.add(box);
        this.endPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(this.endPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.durationPanel = new JPanel();
        this.durationPanel.setLayout(new BoxLayout(this.durationPanel, 1));
        this.durationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Duration "), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.durationChooser = new JDurationChooser(1, ChronoUnit.DAYS);
        this.durationChooser.setAmountLimits(1, Integer.MAX_VALUE);
        this.durationPanel.add(this.durationChooser);
        this.durationPanel.add(Box.createHorizontalGlue());
        this.durationPanel.setAlignmentX(0.0f);
        this.add(this.durationPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        Box saveBox = Box.createVerticalBox();
        saveBox.setAlignmentX(0.0f);
        saveBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Remember As "), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.nameField = new JTextField();
        this.nameField.setColumns(30);
        this.nameField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                TimeWindowDialog.this.saveCheck.setEnabled(!TimeWindowDialog.this.nameField.getText().trim().isEmpty());
            }
        });
        saveBox.add(this.nameField);
        saveBox.add(Box.createRigidArea(new Dimension(0, 5)));
        this.saveCheck = new JCheckBox("Remember between sessions");
        saveBox.add(this.saveCheck);
        this.add(saveBox);
        this.set(range);
        this.startFixedButton.addActionListener(this::onUserAction);
        this.startRelButton.addActionListener(this::onUserAction);
        this.endFixedButton.addActionListener(this::onUserAction);
        this.endRelButton.addActionListener(this::onUserAction);
        this.startChooser.addListener(this::onUserAction);
        this.startDuraChooser.addListener(this::onUserAction);
        this.endChooser.addListener(this::onUserAction);
        this.durationChooser.addListener(this::onUserAction);
    }

    public static TimeWindow editTimeWindow(JComponent parent, TimeWindow seed) {
        range = seed;
        okButton = new JButton("  OK  ");
        TimeWindowDialog tsp = new TimeWindowDialog();
        okButton.addActionListener(e -> {
            tsp.getRange();
            Window w = SwingUtilities.getWindowAncestor(tsp);
            if (w != null) {
                w.setVisible(false);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> {
            range = null;
            Window w = SwingUtilities.getWindowAncestor(tsp);
            if (w != null) {
                w.setVisible(false);
            }
        });
        JOptionPane.showOptionDialog(parent, tsp, "Select time range", 2, -1, null, new Object[]{okButton, cancelButton}, null);
        okButton = null;
        return range;
    }

    private void checkValidy() {
        boolean ok = false;
        okButton.setEnabled(ok);
    }

    private TimeWindow getRange() {
        long end;
        String name = this.nameField.getText().trim();
        boolean persistent = !name.isEmpty() && this.saveCheck.isSelected();
        long start = this.startFixedButton.isSelected() ? this.startChooser.get().getEpochSecond() : -this.startDuraChooser.get();
        long l = end = this.endFixedButton.isSelected() ? this.endChooser.get().getEpochSecond() : 0L;
        if (range == null) {
            range = new TimeWindow(name, start, end, persistent);
        } else {
            range.set(name, start, end, persistent);
        }
        return range;
    }

    private void set(TimeWindow window) {
        if (window == null) {
            window = new TimeWindow("", "now - 86400", "now", false);
        }
        Instant startTime = null;
        boolean startFixed = window.isLowerEdgeFixed();
        boolean endFixed = window.isUpperEdgeFixed();
        if (startFixed) {
            this.startFixedButton.setSelected(true);
            startTime = Instant.ofEpochMilli(window.getLowerEdge(0L));
            this.startChooser.set(startTime);
        } else {
            this.startRelButton.setSelected(true);
            long dura = window.getLowerEdgeDelay();
            this.startDuraChooser.set(dura / 1000L);
        }
        if (endFixed) {
            this.endFixedButton.setSelected(true);
            Instant endTime = Instant.ofEpochMilli(window.getUpperEdge(0L));
            this.endChooser.set(endTime);
            this.durationChooser.set(Duration.between(startTime, endTime).getSeconds());
        } else {
            this.endRelButton.setSelected(true);
        }
        this.onUserAction(null);
        this.saveCheck.setSelected(window.isPersistent());
        String name = window.getName();
        if (name != null && !name.isEmpty()) {
            this.nameField.setText(name);
            this.saveCheck.setEnabled(true);
        } else {
            this.saveCheck.setEnabled(false);
        }
    }

    private void onUserAction(Object source) {
        if (source instanceof EventObject) {
            source = ((EventObject)source).getSource();
        }
        if (source == this.startChooser) {
            Instant start = this.startChooser.get();
            if (this.endFixedButton.isSelected()) {
                Object last = this.lastChooser(source);
                Instant end = this.endChooser.get();
                long duration = this.durationChooser.get();
                long gap = Duration.between(start, end).getSeconds();
                if ((last == null || last == this.endChooser) && gap > 0L) {
                    this.durationChooser.set(gap);
                } else {
                    this.endChooser.set(start.plusSeconds(duration));
                }
            } else {
                long beforeNow = Duration.between(start, Instant.now()).getSeconds();
                if (beforeNow <= 0L) {
                    this.endFixedButton.setSelected(true);
                    this.endChooser.set(start.plus(1L, ChronoUnit.DAYS));
                    this.durationChooser.set(1, ChronoUnit.DAYS);
                }
            }
        } else if (source == this.endChooser) {
            Instant start = this.startChooser.get();
            Instant end = this.endChooser.get();
            long gap = Duration.between(start, end).getSeconds();
            long duration = this.durationChooser.get();
            Object last = this.lastChooser(source);
            if ((last == null || last == this.startChooser) && gap > 0L) {
                this.durationChooser.set(gap);
            } else {
                this.startChooser.set(end.minusSeconds(duration));
            }
        } else if (source == this.durationChooser) {
            long duration = this.durationChooser.get();
            if (this.endFixedButton.isSelected()) {
                Object last = this.lastChooser(source);
                if (last == null || last == this.endChooser) {
                    Instant end = this.endChooser.get();
                    Instant start = end.minusSeconds(duration);
                    this.startChooser.set(start);
                } else {
                    Instant start = this.startChooser.get();
                    Instant end = start.plusSeconds(duration);
                    this.endChooser.set(end);
                }
            }
        } else if (source != this.startDuraChooser) {
            if (source == this.startFixedButton) {
                ZonedDateTime start = ZonedDateTime.now().minusSeconds(this.startDuraChooser.get());
                this.startChooser.set(start);
            } else if (source == this.startRelButton) {
                if (this.endFixedButton.isSelected()) {
                    this.endRelButton.setSelected(true);
                    this.onUserAction(this.endRelButton);
                    return;
                }
                Instant start = this.startChooser.get();
                long dura = Duration.between(start, Instant.now()).getSeconds();
                this.startDuraChooser.setRounded(dura);
            } else if (source == this.endFixedButton) {
                if (this.startFixedButton.isSelected()) {
                    Instant start = this.startChooser.get();
                    Instant end = Instant.now();
                    long dura = Duration.between(start, end).getSeconds();
                    this.durationChooser.set(dura);
                } else if (this.startFixedButton.isSelected()) {
                    Instant end = ZonedDateTime.now().truncatedTo(ChronoUnit.MINUTES).toInstant();
                    this.endChooser.set(end);
                    Instant start = this.startChooser.get();
                    this.durationChooser.set(Duration.between(start, end).getSeconds());
                } else {
                    this.startFixedButton.setSelected(true);
                    long dura = this.startDuraChooser.get();
                    this.durationChooser.set(dura);
                    Instant end = ZonedDateTime.now().truncatedTo(ChronoUnit.MINUTES).toInstant();
                    this.endChooser.set(end);
                    Instant start = end.minusSeconds(dura);
                    this.startChooser.set(start);
                    this.lastChooser(this.endChooser);
                }
            } else if (source == this.endRelButton) {
                // empty if block
            }
        }
        this.updateEnable();
        if (this.startRelButton.isSelected()) {
            this.startChooser.set(Instant.now().minusSeconds(this.startDuraChooser.get()));
        } else {
            this.startDuraChooser.setRounded(Duration.between(this.startChooser.get(), Instant.now()).getSeconds());
        }
        if (this.endRelButton.isSelected()) {
            this.endChooser.set(Instant.now());
            if (this.startRelButton.isSelected()) {
                this.durationChooser.set(this.startDuraChooser.get());
            } else {
                this.durationChooser.setRounded(Duration.between(this.startChooser.get(), Instant.now()).getSeconds());
            }
        }
    }

    private void updateEnable() {
        if (this.startRelButton.isSelected()) {
            this.startChooser.setEnabled(false);
            this.startDuraChooser.setEnabled(true);
            this.agoLabel.setEnabled(true);
            this.endChooser.setEnabled(false);
            this.durationChooser.setEnabled(false);
            this.durationPanel.setEnabled(false);
        } else if (this.endRelButton.isSelected()) {
            this.startChooser.setEnabled(true);
            this.startDuraChooser.setEnabled(false);
            this.agoLabel.setEnabled(false);
            this.endChooser.setEnabled(false);
            this.durationChooser.setEnabled(false);
            this.durationPanel.setEnabled(false);
        } else {
            this.startChooser.setEnabled(true);
            this.startDuraChooser.setEnabled(false);
            this.agoLabel.setEnabled(false);
            this.endChooser.setEnabled(true);
            this.durationChooser.setEnabled(true);
            this.durationPanel.setEnabled(true);
        }
    }

    Object lastChooser(Object chooser) {
        Object last = this.lastChoosers[0];
        if (last == chooser) {
            return this.lastChoosers[1];
        }
        this.lastChoosers[1] = last;
        this.lastChoosers[0] = chooser;
        return last;
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(() -> {
            TimeWindow tw = null;
            do {
                tw = TimeWindowDialog.editTimeWindow(null, tw);
                System.out.println(tw);
            } while (tw != null);
            Platform.exit();
        });
    }
}

