/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui.jas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lsst.ccs.gconsole.base.filter.GenericFilterPersistable;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

public class PathMonitorFilter
extends GenericFilterPersistable {
    private static final List<String> FIELDS = new ArrayList<String>();
    private final Set<String> exclusions = new HashSet<String>();

    public PathMonitorFilter(List<String> agents, String ... exclSections) {
        super("MyName", agents, Collections.singletonList("/"), "", true, FIELDS);
        this.exclusions.add("state");
        this.exclusions.add("configuration");
        this.exclusions.add("runtimeInfo");
        this.exclusions.addAll(Arrays.asList(exclSections));
    }

    public String getDisplayPath(AgentChannel channel) {
        String path = channel.getLocalPath();
        int i1 = path.indexOf("/");
        if (i1 != -1) {
            int i2;
            String section = path.substring(0, i1).trim();
            if (section.equals("main") && (i2 = path.indexOf("/", i1 + 1)) != -1) {
                section = path.substring(i1 + 1, i2);
                i1 = i2;
            }
            if (!this.exclusions.contains(section)) {
                return section + "//" + path.substring(i1 + 1);
            }
        }
        return null;
    }

    static {
        FIELDS.add(MonitorField.VALUE.getKey());
        FIELDS.add(MonitorField.UNITS.getKey());
        FIELDS.add(MonitorField.LOW_ALARM.getKey());
        FIELDS.add(MonitorField.LOW_WARN.getKey());
        FIELDS.add(MonitorField.ALERT_LOW.getKey());
        FIELDS.add(MonitorField.HIGH_WARN.getKey());
        FIELDS.add(MonitorField.HIGH_ALARM.getKey());
        FIELDS.add(MonitorField.ALERT_HIGH.getKey());
        FIELDS.add(MonitorField.NAME.getKey());
        FIELDS.add(MonitorField.DESCR.getKey());
    }
}

