/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui.jas;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonitorFilter;
import org.lsst.ccs.subsystem.common.ui.jas.PathMonitorFilter;

public class MonOptionalPage
implements OptionalPage {
    private final Map<String, ControlPanel> controls = new ConcurrentHashMap<String, ControlPanel>();
    private final String agentProperty;
    private final Class controlClass;
    private final boolean noMonitor;
    private final String section;
    private final boolean usePath;
    private final String[] exclSections;

    public MonOptionalPage(String agentProperty, Class controlClass, String section, boolean usePath, String ... exclSections) {
        this(agentProperty, controlClass, section, false, usePath, exclSections);
    }

    public MonOptionalPage(String agentProperty, Class controlClass, String section, boolean noMonitor, boolean usePath, String ... exclSections) {
        this.agentProperty = agentProperty;
        this.controlClass = controlClass;
        this.noMonitor = noMonitor;
        this.section = section;
        this.usePath = usePath;
        this.exclSections = exclSections;
    }

    public boolean isAutoOpen() {
        return false;
    }

    public String getPage(AgentInfo agent) {
        return agent != null && agent.hasAgentProperty(this.agentProperty) ? this.getPageName(agent) : null;
    }

    public boolean agentDisconnected(AgentInfo agent) {
        ControlPanel control = this.controls.get(this.getPageName(agent));
        if (control == null) {
            return true;
        }
        control.disableSystem();
        return false;
    }

    public JComponent open(AgentInfo agent, JComponent existingComponent) {
        JPanel panel;
        String pageName = this.getPageName(agent);
        String agentName = agent.getName();
        ControlPanel control = this.controls.get(pageName);
        if (control != null) {
            control.initControlPanel();
            return existingComponent;
        }
        try {
            control = (ControlPanel)this.controlClass.newInstance();
            this.controls.put(pageName, control);
        }
        catch (Exception e) {
            return null;
        }
        JPanel cPanel = control.getControlPanel(new CommandSender(agentName));
        if (!this.noMonitor) {
            TabbedView view = new TabbedView();
            view.setViewFactory(name -> new SectionedTableView());
            if (this.usePath) {
                view.setFilter((AgentChannelsFilter)new PathMonitorFilter(Collections.singletonList(agentName), this.exclSections));
            } else {
                view.setFilter((AgentChannelsFilter)new MonitorFilter(Collections.singletonList(agentName)));
            }
            view.install();
            panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)view.getPanel(), "Center");
            panel.add((Component)cPanel, "South");
        } else {
            panel = cPanel;
        }
        panel.setName(agentName + (this.section == null ? "" : " " + this.section));
        AgentMessagingLayer aml = Console.getConsole().getMessagingAccess();
        aml.addStatusMessageListener(control.getListener(), msg -> msg.getOriginAgentInfo().getName().equals(agentName) && msg instanceof StatusSubsystemData);
        control.initControlPanel();
        return panel;
    }

    public void closed(String pageName) {
        ControlPanel control = this.controls.remove(pageName);
        if (control == null) {
            throw new RuntimeException("No page exists with the name " + pageName);
        }
        Console.getConsole().getMessagingAccess().removeStatusMessageListener(control.getListener());
    }

    private String getPageName(AgentInfo agent) {
        return "CCS Subsystems/" + agent.getName() + "/" + (this.section == null ? agent.getName() : this.section);
    }
}

