/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonOptionalPage;
import org.lsst.ccs.subsystem.rafts.data.ImageState;
import org.lsst.ccs.subsystem.rafts.data.RaftState;
import org.lsst.ccs.subsystem.rafts.data.RaftsAgentProperties;
import org.lsst.ccs.subsystem.rafts.ui.RaftsControlPanel;
import org.lsst.ccs.subsystem.rafts.ui.RaftsMonitorPanel;

@Plugin(name="Rafts Console Plugin", description="Rafts Console Plugin")
public class RaftsConsolePlugin
extends ConsolePlugin {
    public void initialize() {
        OptionalPage.getService().add((OptionalPage)new MonOptionalPage(RaftsAgentProperties.RAFT_TYPE_AGENT_PROPERTY, RaftsMonitor.class, "Monitor", false, false, new String[0]));
        OptionalPage.getService().add((OptionalPage)new MonOptionalPage(RaftsAgentProperties.RAFT_TYPE_AGENT_PROPERTY, RaftsControl.class, "Control", true, false, new String[0]));
    }

    public static class RaftsMonitor
    extends ControlPanel
    implements StatusMessageListener {
        private CommandSender cmdSender;
        private RaftsMonitorPanel ctrlPanel;

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("RaftState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        public JPanel getControlPanel(CommandSender sndr) {
            this.cmdSender = sndr;
            this.ctrlPanel = new RaftsMonitorPanel(sndr);
            return this.ctrlPanel;
        }

        public void initControlPanel() {
            this.updateControlPanel(this.cmdSender.sendCommand(null, "getFullState", new Object[0]));
        }

        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updateControlPanel((RaftState)obj);
        }

        public void disableSystem() {
            this.ctrlPanel.disableSystem();
        }

        public StatusMessageListener getListener() {
            return this;
        }
    }

    public static class RaftsControl
    extends ControlPanel
    implements StatusMessageListener {
        private CommandSender cmdSender;
        private RaftsControlPanel ctrlPanel;

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("RaftState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                } else if (sd.getDataKey().equals("ImageState")) {
                    this.ctrlPanel.reportImage((ImageState)sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        public JPanel getControlPanel(CommandSender sndr) {
            this.cmdSender = sndr;
            this.ctrlPanel = new RaftsControlPanel(sndr);
            return this.ctrlPanel;
        }

        public void initControlPanel() {
            this.updateControlPanel(this.cmdSender.sendCommand(null, "getFullState", new Object[0]));
        }

        public void updateControlPanel(Object obj) {
            this.ctrlPanel.enableSystem();
        }

        public void disableSystem() {
            this.ctrlPanel.disableSystem();
        }

        public StatusMessageListener getListener() {
            return this;
        }
    }
}

