/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultMonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTableCellRenderer;
import org.lsst.ccs.gconsole.plugins.monitor.Updatable;
import org.lsst.ccs.gconsole.plugins.trending.TrendingService;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

public abstract class MonitorTable
extends AbstractTableModel
implements Updatable {
    public static final MonitorFormat DEFAULT_FORMAT = new MonitorFormat();
    public static final List<MonitorField> DEFAULT_FIELDS = Collections.unmodifiableList(Arrays.asList(MonitorField.VALUE, MonitorField.UNITS, MonitorField.LOW_ALARM, MonitorField.ALERT_LOW, MonitorField.HIGH_ALARM, MonitorField.ALERT_HIGH, MonitorField.DESCR));
    public static final List<MonitorField> DEFAULT_COMPACT_FIELDS = Collections.unmodifiableList(Arrays.asList(MonitorField.VALUE));
    protected int nRows;
    protected int nColumns;
    protected ArrayList<ArrayList<DefaultMonitorCell>> cells;
    protected MonitorFormat format = DEFAULT_FORMAT;
    protected Listener listener;
    protected final Event CELLS_EVENT = new Event(this, Event.Reason.CELLS);
    protected final Event TABLE_EVENT = new Event(this, Event.Reason.TABLE);

    protected MonitorTable() {
    }

    protected MonitorTable(DefaultMonitorCell[][] cells) {
        this.nRows = cells.length;
        this.nColumns = cells[0].length;
        this.cells = new ArrayList(this.nRows);
        for (DefaultMonitorCell[] row : cells) {
            this.cells.add(new ArrayList<DefaultMonitorCell>(Arrays.asList(row)));
        }
    }

    public void destroy() {
    }

    public void setFormat(MonitorFormat format) {
        this.format = format;
        if (this.cells != null) {
            boolean change = false;
            for (ArrayList<DefaultMonitorCell> row : this.cells) {
                for (DefaultMonitorCell cell : row) {
                    if (cell == null || cell.getField() == null || !cell.getField().isUpdatable() || cell.getField().equals(MonitorField.NULL)) continue;
                    change = format.format(cell);
                }
            }
            if (change) {
                this.fireChangeEvent(this.CELLS_EVENT);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.nRows;
    }

    @Override
    public int getColumnCount() {
        return this.nColumns;
    }

    @Override
    public FormattedValue getValueAt(int row, int column) {
        return this.cells.get(row).get(column).getFormattedValue();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        DefaultMonitorCell cell = this.cells.get(row).get(column);
        FormattedValue fv = cell.getFormattedValue();
        return fv != null && fv.isEditable();
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        DefaultMonitorCell cell = this.cells.get(row).get(column);
        if (cell.getChannels().size() != 1) {
            return;
        }
        MonitorField field = cell.getField();
        if (field == null) {
            return;
        }
        AgentChannel channel = cell.getChannels().get(0).getChannel();
        field.setValue(aValue, channel);
    }

    @Override
    public void update(DisplayChannel item, List<MonitorField> fields) {
        fields.forEach(field -> {
            List<int[]> affectedCells = this.getCells(item, (MonitorField)field);
            for (int[] index : affectedCells) {
                DefaultMonitorCell cell = this.cells.get(index[0]).get(index[1]);
                field = cell.getField();
                FormattedValue data = this.format.format((MonitorField)field, item);
                if (data.equals(cell.getFormattedValue())) continue;
                cell.setFormattedValue(data);
                this.fireTableCellUpdated(index[0], index[1]);
            }
        });
        this.fireChangeEvent(this.CELLS_EVENT);
    }

    @Override
    public void update(DisplayChannel channelHandle) {
        this.update(channelHandle, Collections.singletonList(null));
    }

    protected List<int[]> getCells(DisplayChannel item, MonitorField field) {
        ArrayList<int[]> out = new ArrayList<int[]>();
        for (int row = 0; row < this.nRows; ++row) {
            for (int col = 0; col < this.nColumns; ++col) {
                DefaultMonitorCell cell = this.cells.get(row).get(col);
                if (!cell.getChannels().contains(item) || field != null && !field.equals(cell.getField())) continue;
                out.add(new int[]{row, col});
            }
        }
        return out;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    protected void fireChangeEvent(Event.Reason reason) {
        this.fireChangeEvent(reason == Event.Reason.CELLS ? this.CELLS_EVENT : this.TABLE_EVENT);
    }

    protected void fireChangeEvent(Event event) {
        if (this.listener != null) {
            this.listener.stateChanged(event);
        }
    }

    public JTable getTable() {
        JTable table = this.makeTable();
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        TableCellRenderer headerRenderer = header.getDefaultRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setHorizontalAlignment(0);
        }
        MonitorTableCellRenderer renderer = new MonitorTableCellRenderer();
        renderer.setEnsureWidth(true);
        table.setDefaultRenderer(Object.class, renderer);
        table.setAutoResizeMode(3);
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.setRowHeight(table.getRowHeight() + 2);
        table.setShowGrid(true);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MonitorTable.this.tableMouseClicked(evt);
            }
        });
        for (int col = 0; col < this.nColumns; ++col) {
            TableColumn column = table.getColumnModel().getColumn(col);
            Component comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            int maxWidth = comp.getPreferredSize().width;
            for (int row = 0; row < this.nRows; ++row) {
                comp = renderer.getTableCellRendererComponent(table, this.getValueAt(row, col), false, false, row, col);
                maxWidth = Math.max(maxWidth, comp.getPreferredSize().width);
            }
            column.setPreferredWidth(maxWidth);
        }
        return table;
    }

    protected JTable makeTable() {
        return new JTable(this);
    }

    protected void tableMouseClicked(MouseEvent evt) {
        List<DisplayChannel> items;
        DefaultMonitorCell cc;
        int nClick = evt.getClickCount();
        JTable table = (JTable)evt.getSource();
        Point point = evt.getPoint();
        int row = table.rowAtPoint(point);
        int column = table.columnAtPoint(point);
        if (nClick == 1) {
            DefaultMonitorCell cc2 = this.cells.get(row).get(column);
            FormattedValue fv = cc2.getFormattedValue();
            if (fv != null && fv.getClick1() != null) {
                fv.getClick1().accept(cc2);
            }
        } else if (nClick == 2 && (cc = this.cells.get(row).get(column)).getField().equals(MonitorField.VALUE) && (items = cc.getChannels()).size() == 1) {
            DisplayChannel item = items.get(0);
            String trendingKey = (String)item.getChannel().get("_key_");
            if (trendingKey == null) {
                trendingKey = item.getChannel().getLocalPath();
            }
            String[] path = new String[]{item.getChannel().getAgentName(), trendingKey};
            TrendingService trending = (TrendingService)Console.getConsole().getConsoleLookup().lookup(TrendingService.class);
            if (trending == null) {
                return;
            }
            trending.show(path);
        }
    }

    public boolean showHeader() {
        return true;
    }

    public static List<MonitorField> trimAbsentFields(List<MonitorField> fields, Collection<DisplayChannel> channels, Collection<MonitorField> exclude) {
        LinkedHashSet<MonitorField> requestedFields = new LinkedHashSet<MonitorField>(fields);
        if (exclude != null) {
            requestedFields.removeAll(exclude);
        }
        HashSet<MonitorField> presentFields = new HashSet<MonitorField>();
        if (requestedFields.remove(MonitorField.VALUE)) {
            presentFields.add(MonitorField.VALUE);
        }
        for (DisplayChannel ch : channels) {
            AgentChannel channel = ch.getChannel();
            if (channel == null) continue;
            Iterator it = requestedFields.iterator();
            while (it.hasNext()) {
                MonitorField f = (MonitorField)it.next();
                if (f.getValue(channel) == null) continue;
                presentFields.add(f);
                it.remove();
            }
            if (!requestedFields.isEmpty()) continue;
            break;
        }
        if (fields.size() == presentFields.size()) {
            return fields;
        }
        if (presentFields.contains(MonitorField.ALERT_LOW)) {
            presentFields.add(MonitorField.ALERT_HIGH);
        } else if (presentFields.contains(MonitorField.ALERT_HIGH)) {
            presentFields.add(MonitorField.ALERT_LOW);
        }
        ArrayList<MonitorField> out = new ArrayList<MonitorField>(presentFields.size());
        for (MonitorField f : fields) {
            if (!presentFields.contains(f)) continue;
            out.add(f);
        }
        return out;
    }

    public Serializable save() {
        return null;
    }

    public void restore(Serializable storageBean) {
    }

    public static interface Listener {
        public void stateChanged(Event var1);
    }

    public static class Event
    extends EventObject {
        private final Reason reason;

        public Event(MonitorTable source, Reason reason) {
            super(source);
            this.reason = reason;
        }

        @Override
        public MonitorTable getSource() {
            return (MonitorTable)super.getSource();
        }

        public Reason getReason() {
            return this.reason;
        }

        public static enum Reason {
            CELLS,
            TABLE;

        }
    }
}

