/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base.filter;

import java.util.regex.Pattern;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;

public class RegExFilter
extends AbstractChannelsFilter {
    private final String name;
    private final Pattern pattern;
    private final boolean wholePath;

    @Create(category="AgentChannelsFilter", name="Regular expression filter", path="Built-In/Regular Expression", description="Channels filter that uses a regular expression to select channels and leaves their paths unchanged.")
    public RegExFilter(@Par(def="_null_", desc="Filter name. Optional.") String name, @Par(desc="Regular expression to be applied to the channel path.") String regex, @Par(def="false", desc="Match the whole path. If checked, a channel is accepted only if the provided regular expression matches its entire path.") boolean wholePath) {
        this.name = name;
        if (regex == null || regex.isEmpty()) {
            throw new IllegalArgumentException("The regular expression cannot be empty");
        }
        this.pattern = Pattern.compile(regex);
        this.wholePath = wholePath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayPath(String originPath) {
        boolean accept = this.wholePath ? this.pattern.matcher(originPath).matches() : this.pattern.matcher(originPath).find();
        return accept ? originPath : null;
    }

    @Override
    public String getOriginPath(String displayPath) {
        return displayPath;
    }
}

