/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.Objects;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class AgentLockInfo
implements AgentLock,
Serializable {
    private static final long serialVersionUID = 4416294268287507663L;
    private final String agentName;
    private final String ownerAgent;
    private final String userId;
    private final int maxLevel;
    private final CCSTimeStamp timeStamp;
    private final Status status;

    public AgentLockInfo(String agentName, String ownerAgent) {
        this.agentName = agentName;
        this.userId = null;
        this.maxLevel = 99999;
        this.status = Status.REQUESTED;
        this.timeStamp = CCSTimeStamp.currentTime();
        this.ownerAgent = ownerAgent;
    }

    public AgentLockInfo(String agentName, String ownerAgent, String userId, int maxLevel, Status status, CCSTimeStamp timeStamp) {
        this.agentName = agentName;
        this.ownerAgent = ownerAgent;
        this.userId = userId;
        this.maxLevel = maxLevel;
        this.status = status;
        this.timeStamp = timeStamp;
    }

    public AgentLockInfo(AgentLockInfo lock, Status status, CCSTimeStamp timeStamp) {
        this.agentName = lock.agentName;
        this.userId = lock.userId;
        this.maxLevel = lock.maxLevel;
        this.status = status;
        this.timeStamp = timeStamp;
        this.ownerAgent = lock.ownerAgent;
    }

    @Override
    public String getAgentName() {
        return this.agentName;
    }

    @Override
    public String getOwnerAgentName() {
        return this.ownerAgent;
    }

    @Override
    public String getUserID() {
        return this.userId;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    public Status getStatus() {
        return this.status;
    }

    public CCSTimeStamp getTimeStamp() {
        return this.timeStamp;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.agentName);
        hash = 67 * hash + Objects.hashCode(this.userId);
        hash = 67 * hash + this.maxLevel;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgentLockInfo other = (AgentLockInfo)obj;
        if (!Objects.equals(this.agentName, other.agentName)) {
            return false;
        }
        if (!Objects.equals(this.userId, other.userId)) {
            return false;
        }
        return this.maxLevel == other.maxLevel;
    }

    public String toString() {
        return "Lock " + this.agentName + " by " + this.getOwnerName() + " " + (Object)((Object)this.status) + " at " + this.timeStamp.getUTCInstant().toString();
    }

    public static enum Status {
        REQUESTED,
        ACKNOWLEDGED,
        RELEASED,
        REJECTED,
        LEVEL_UPDATE;

    }
}

