/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.registry;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseStyle;
import hep.aida.IPlotterFactory;
import hep.aida.IPlotterStyle;
import hep.aida.ref.plotter.BaseStyle;
import hep.aida.ref.plotter.style.registry.BaseStyleStore;
import hep.aida.ref.plotter.style.registry.IStyleRule;
import hep.aida.ref.plotter.style.registry.IStyleStore;
import hep.aida.ref.plotter.style.registry.JELRule;
import hep.aida.ref.plotter.style.registry.StyleStoreEntry;
import hep.aida.ref.plotter.style.registry.XMLStyleStore;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.freehep.xml.util.XMLWriter;

public class StyleStoreXMLWriter
extends XMLWriter {
    public static void writeToFile(String fileName, IStyleStore store) throws IOException {
        StyleStoreXMLWriter.writeToFile(fileName, store, false);
    }

    public static void writeToFile(String fileName, IStyleStore store, boolean writeAllParameters) throws IOException {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        StyleStoreXMLWriter xmlWriter = new StyleStoreXMLWriter(writer);
        xmlWriter.writeXMLStyleStore(store, writeAllParameters);
        xmlWriter.close();
    }

    public StyleStoreXMLWriter(Writer writer) throws IOException {
        super(writer);
        this.openDoc("1.0", "ISO-8859-1", false);
        this.referToDTD("aidaStyleStore", "http://java.freehep.org/schemas/jaida/1.0/StyleStoreDTD.dtd");
    }

    public void close() throws IOException {
        super.close();
    }

    public void writeXMLStyleStore(IStyleStore store) {
        this.writeXMLStyleStore(store, false);
    }

    public void writeXMLStyleStore(IStyleStore store, boolean writeAllParameters) {
        this.setAttribute("storeName", store.getStoreName());
        this.setAttribute("storeType", store.getStoreType());
        this.setAttribute("isReadOnly", store.isReadOnly());
        this.openTag("aidaStyleStore");
        String[] names = store.getAllStyleNames();
        if (store instanceof BaseStyleStore) {
            for (int i = 0; i < names.length; ++i) {
                StyleStoreEntry entry = ((BaseStyleStore)store).getStoreEntry(names[i]);
                this.storeEntryToXML(names[i], entry.getPreviewType().getName(), store.getStyle(names[i]), entry.getRule());
            }
        } else {
            for (int i = 0; i < names.length; ++i) {
                this.storeEntryToXML(names[i], store.getStyle(names[i]), store.getRuleForStyle(names[i]));
            }
        }
        this.closeTag();
    }

    public void storeEntryToXML(String name, IPlotterStyle style, IStyleRule rule) {
        String previewType = StyleStoreEntry.DEFAULT_ENTRY_TYPE;
        this.storeEntryToXML(name, previewType, style, rule);
    }

    public void storeEntryToXML(String name, String type, IPlotterStyle style, IStyleRule rule) {
        this.setAttribute("entryName", name);
        if (type != null) {
            this.setAttribute("entryType", type);
        }
        this.openTag("aidaStyleStoreEntry");
        this.styleRuleToXML(rule);
        this.plotterStyleToXML(style);
        this.closeTag();
    }

    public void styleRuleToXML(IStyleRule rule) {
        this.setAttribute("ruleValue", rule.getDescription());
        if (rule instanceof JELRule && ((JELRule)rule).getType() != null) {
            this.setAttribute("ruleType", ((JELRule)rule).getType());
        }
        this.printTag("aidaStyleRule");
    }

    public void plotterStyleToXML(IPlotterStyle style) {
        this.plotterStyleToXML(style, false);
    }

    public void plotterStyleToXML(IPlotterStyle style, boolean writeAllParameters) {
        if (this.isStyleEmpty((IBaseStyle)style, writeAllParameters)) {
            return;
        }
        this.openTag("aidaPlotterStyle");
        IBaseStyle[] children = style.children();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                this.styleToXML(children[i], writeAllParameters);
            }
        }
        this.styleParametersToXML((IBaseStyle)style, writeAllParameters);
        this.closeTag();
    }

    void styleToXML(IBaseStyle style) {
        this.styleToXML(style, false);
    }

    void styleToXML(IBaseStyle style, boolean writeAllParameters) {
        if (this.isStyleEmpty(style, writeAllParameters)) {
            return;
        }
        this.setAttribute("type", style.name());
        this.openTag("aidaStyle");
        IBaseStyle[] children = style.children();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                this.styleToXML(children[i], writeAllParameters);
            }
        }
        this.styleParametersToXML(style, writeAllParameters);
        this.closeTag();
    }

    void styleParametersToXML(IBaseStyle style, boolean writeAllParameters) {
        String[] parNames = style.availableParameters();
        if (parNames != null) {
            for (int i = 0; i < parNames.length; ++i) {
                String name = parNames[i];
                String value = style.parameterValue(name);
                if (value == null) {
                    value = "null";
                }
                boolean isSet = true;
                String type = String.class.getName();
                String[] possibleValues = null;
                if (style instanceof BaseStyle) {
                    isSet = ((BaseStyle)style).isParameterSet(name);
                    type = ((BaseStyle)style).parameter(name).type().getName();
                    possibleValues = ((BaseStyle)style).availableParameterOptions(name);
                }
                String options = null;
                if (possibleValues != null && possibleValues.length > 0) {
                    options = "\"" + (String)possibleValues[0] + "\"";
                    for (int o = 1; o < possibleValues.length; ++o) {
                        options = options + ", \"" + possibleValues[o] + "\"";
                    }
                }
                if (!isSet && !writeAllParameters) continue;
                this.setAttribute("attributeName", name);
                this.setAttribute("attributeValue", value);
                if (options != null) {
                    this.setAttribute("attributeOptions", options);
                }
                this.printTag("aidaStyleAttribute");
            }
        }
    }

    boolean isStyleEmpty(IBaseStyle style) {
        return this.isStyleEmpty(style, false);
    }

    boolean isStyleEmpty(IBaseStyle style, boolean writeAllParameters) {
        IBaseStyle[] children;
        boolean isEmpty = true;
        String[] parNames = style.availableParameters();
        if (parNames != null) {
            for (int i = 0; i < parNames.length; ++i) {
                String name = parNames[i];
                boolean isSet = true;
                if (style instanceof BaseStyle) {
                    isSet = ((BaseStyle)style).isParameterSet(name);
                }
                if (!isSet && !writeAllParameters) continue;
                return false;
            }
        }
        if ((children = style.children()) != null) {
            for (int i = 0; i < children.length; ++i) {
                if (this.isStyleEmpty(children[i])) continue;
                return false;
            }
        }
        return isEmpty;
    }

    public static void main(String[] args) throws Exception {
        XMLStyleStore store = new XMLStyleStore("XML Store 2", XMLStyleStore.TYPE, false);
        IPlotterFactory pf = IAnalysisFactory.create().createPlotterFactory();
        IPlotterStyle style1 = pf.createPlotterStyle();
        style1.dataBoxStyle().setVisible(true);
        style1.dataBoxStyle().backgroundStyle().setPattern("hatched");
        JELRule rule1 = new JELRule("OverlayNumber==1");
        store.addStyle("Style-1", style1, rule1);
        IPlotterStyle style2 = pf.createPlotterStyle();
        style2.dataBoxStyle().setVisible(false);
        style2.dataBoxStyle().backgroundStyle().setColor("White");
        JELRule rule2 = new JELRule("RegionNumber>=2");
        store.addStyle("Style-2", style2, rule2);
        String fileName = "C:/TEMP/xmlStore.xml";
        StyleStoreXMLWriter.writeToFile(fileName, store);
    }
}

