/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystem.monitor.ui.MonitorGui;
import org.lsst.ccs.subsystem.rafts.data.ImageState;
import org.lsst.ccs.subsystem.rafts.ui.REBConfigPanel;
import org.lsst.ccs.subsystem.rafts.ui.RaftsControlGui;
import org.lsst.ccs.utilities.logging.Logger;

public class RaftsControlPanel
extends MonitorGui.Panel
implements REBConfigPanel.Parent {
    private static final Color RED = new Color(150, 0, 0);
    private static final Color GREEN = new Color(0, 150, 0);
    private static final String LF = "\n";
    private final JPanel mainPanel = new JPanel();
    private final JPanel subMainPanel = new JPanel();
    private final JPanel raftsStPanel = new JPanel();
    private final JLabel lblStName = new JLabel("Rafts Status: ");
    private final JLabel lblStValue = new JLabel();
    private final JPanel rebStPanel = new JPanel();
    private final JLabel lblRbName = new JLabel("Connected REBs:");
    private final JLabel lblRebs = new JLabel();
    private final JPanel cfgPanel = new JPanel();
    private JButton[] btnCfgREB = new JButton[0];
    private final JButton btnCfgSave = new JButton("Save");
    private final JPanel setPanel = new JPanel();
    private final JButton btnLoadDacs = new JButton("Load DACs");
    private final JButton btnLoadAspics = new JButton("Load ASPICs");
    private final JButton btnLoadCabacs = new JButton("Load CABACs");
    private final JCheckBox cbxBackBias = new JCheckBox("Back Bias");
    private final JPanel seqPanel = new JPanel();
    private final JButton btnSeqLoad = new JButton("Load...");
    private final JButton btnSeqStart = new JButton("Start");
    private final JButton btnSeqStop = new JButton("Stop");
    private final JButton btnSeqStep = new JButton("Step");
    private final JCheckBox cbxScanMode = new JCheckBox("Scan Mode");
    private final JButton btnResetScan = new JButton("Reset Scan");
    private final JCheckBox cbxPattern = new JCheckBox("Pattern");
    private final JButton btnResetFE = new JButton("Reset FE");
    private final JPanel imgPanel = new JPanel();
    private final JButton btnAcquire = new JButton("Acquire");
    private final JButton btnSetDir = new JButton("Directory...");
    private final JButton btnSaveRaw = new JButton("Save Raw");
    private final JButton btnSaveFits = new JButton("Save FITS");
    private final JPanel msgPanel = new JPanel();
    private final JTextArea taMessage = new JTextArea(8, 40);
    private final JScrollPane spMessage = new JScrollPane(this.taMessage);
    private final RaftsControlGui gui;
    private final Logger log;
    private List<String> rebNames = new ArrayList<String>();
    private String imageDir;
    private String rafts;
    private static final long serialVersionUID = 1L;

    public RaftsControlPanel(RaftsControlGui gui) {
        this.gui = gui;
        this.log = gui.getLogger();
        this.initStatusPanels();
        this.initConfigPanel();
        this.initSetupPanel();
        this.initSequencerPanel();
        this.initImagePanel();
        this.initSubMainPanel();
        this.initMessagePanel();
        this.initMainPanel();
        this.initTopPanel();
    }

    @Override
    public Object sendCommand(String name, String command, Object ... params) {
        if (this.rafts != null) {
            return this.sendSubsysCommand(this.rafts, name, command, params);
        }
        this.displayError("Rafts system not running");
        return null;
    }

    @Override
    public void display(String message) {
        this.taMessage.append(message + LF);
    }

    private void initStatusPanels() {
        this.raftsStPanel.add(this.lblStName);
        this.lblStValue.setForeground(RED);
        this.lblStValue.setText("STOPPED");
        this.raftsStPanel.add(this.lblStValue);
        this.rebStPanel.add(this.lblRbName);
        this.lblRebs.setText("none");
        this.rebStPanel.add(this.lblRebs);
    }

    private void initConfigPanel() {
        TitledBorder border = new TitledBorder("Config");
        border.setTitleJustification(2);
        this.cfgPanel.setBorder(border);
        this.cfgPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.btnCfgREB = new JButton[this.rebNames.size()];
        for (int j = 0; j < this.btnCfgREB.length; ++j) {
            JButton btn;
            this.btnCfgREB[j] = btn = new JButton(this.rebNames.get(j) + "...");
            this.cfgPanel.add((Component)btn, gbc);
            btn.setFocusable(false);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RaftsControlPanel.this.cfgREB(e);
                }
            });
            ++gbc.gridy;
        }
        this.cfgPanel.add((Component)this.btnCfgSave, gbc);
        this.btnCfgSave.setFocusable(false);
        this.btnCfgSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RaftsControlPanel.this.sendCommand(null, "saveNamedConfig", "");
            }
        });
    }

    private void initSetupPanel() {
        TitledBorder border = new TitledBorder("Setup");
        border.setTitleJustification(2);
        this.setPanel.setBorder(border);
        this.setPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.setPanel.add((Component)this.btnLoadDacs, gbc);
        this.btnLoadDacs.setFocusable(false);
        this.btnLoadDacs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object reply = RaftsControlPanel.this.sendCommand(null, "loadDacs", true);
                if (reply != null) {
                    RaftsControlPanel.this.display((Integer)reply + " DACs loaded");
                }
                if ((reply = RaftsControlPanel.this.sendCommand(null, "loadBiasDacs", true)) != null) {
                    RaftsControlPanel.this.display((Integer)reply + " bias DACs loaded");
                }
            }
        });
        ++gbc.gridy;
        this.setPanel.add((Component)this.btnLoadAspics, gbc);
        this.btnLoadAspics.setFocusable(false);
        this.btnLoadAspics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer count = (Integer)RaftsControlPanel.this.sendCommand(null, "loadAspics", true);
                if (count == null) {
                    return;
                }
                List masks = (List)RaftsControlPanel.this.sendCommand(null, "checkAspics", new Object[0]);
                RaftsControlPanel.this.display(count + " ASPICs loaded: " + RaftsControlPanel.this.getResult(masks));
            }
        });
        ++gbc.gridy;
        this.setPanel.add((Component)this.btnLoadCabacs, gbc);
        this.btnLoadCabacs.setFocusable(false);
        this.btnLoadCabacs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer count = (Integer)RaftsControlPanel.this.sendCommand(null, "loadCabacs", new Object[0]);
                if (count == null) {
                    return;
                }
                List masks = (List)RaftsControlPanel.this.sendCommand(null, "checkCabacs", new Object[0]);
                RaftsControlPanel.this.display(count + " CABACs loaded: " + RaftsControlPanel.this.getResult(masks));
            }
        });
        ++gbc.gridy;
        this.setPanel.add((Component)this.cbxBackBias, gbc);
        this.cbxBackBias.setFocusable(false);
        this.cbxBackBias.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RaftsControlPanel.this.sendCommand(null, "setBackBias", RaftsControlPanel.this.cbxBackBias.isSelected());
                RaftsControlPanel.this.setBackBiasCB();
            }
        });
    }

    private void initSequencerPanel() {
        TitledBorder border = new TitledBorder("Sequencer");
        border.setTitleJustification(2);
        this.seqPanel.setBorder(border);
        this.seqPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.seqPanel.add((Component)this.btnSeqLoad, gbc);
        this.btnSeqLoad.setFocusable(false);
        this.btnSeqLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RaftsControlPanel.this.seqLoad();
            }
        });
        ++gbc.gridy;
        this.seqPanel.add((Component)this.btnSeqStart, gbc);
        this.btnSeqStart.setFocusable(false);
        this.btnSeqStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RaftsControlPanel.this.sendCommand(null, "startSequencer", new Object[0]);
            }
        });
        ++gbc.gridy;
        this.seqPanel.add((Component)this.btnSeqStop, gbc);
        this.btnSeqStop.setFocusable(false);
        this.btnSeqStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RaftsControlPanel.this.sendCommand(null, "stopSequencer", new Object[0]);
            }
        });
        ++gbc.gridy;
        this.seqPanel.add((Component)this.btnSeqStep, gbc);
        this.btnSeqStep.setFocusable(false);
        this.btnSeqStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RaftsControlPanel.this.sendCommand(null, "stepSequencer", new Object[0]);
            }
        });
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.seqPanel.add((Component)this.cbxScanMode, gbc);
        this.cbxScanMode.setFocusable(false);
        this.cbxScanMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RaftsControlPanel.this.sendCommand(null, "enableScan", RaftsControlPanel.this.cbxScanMode.isSelected());
                RaftsControlPanel.this.setScanModeCB();
            }
        });
        ++gbc.gridy;
        this.seqPanel.add((Component)this.btnResetScan, gbc);
        this.btnResetScan.setFocusable(false);
        this.btnResetScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RaftsControlPanel.this.sendCommand(null, "resetScan", new Object[0]);
            }
        });
        ++gbc.gridy;
        this.seqPanel.add((Component)this.cbxPattern, gbc);
        this.cbxPattern.setFocusable(false);
        this.cbxPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RaftsControlPanel.this.sendCommand(null, "setDataSource", RaftsControlPanel.this.cbxPattern.isSelected() ? 1 : 0);
                RaftsControlPanel.this.setPatternCB();
            }
        });
        ++gbc.gridy;
        this.seqPanel.add((Component)this.btnResetFE, gbc);
        this.btnResetFE.setFocusable(false);
        this.btnResetFE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RaftsControlPanel.this.sendCommand(null, "resetFirmware", new Object[0]);
                RaftsControlPanel.this.setScanModeCB();
                RaftsControlPanel.this.setPatternCB();
            }
        });
    }

    private void initImagePanel() {
        TitledBorder border = new TitledBorder("Images");
        border.setTitleJustification(2);
        this.imgPanel.setBorder(border);
        this.imgPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.imgPanel.add((Component)this.btnAcquire, gbc);
        this.btnAcquire.setFocusable(false);
        this.btnAcquire.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RaftsControlPanel.this.sendCommand(null, "acquireImage", new Object[0]);
            }
        });
        ++gbc.gridy;
        this.imgPanel.add((Component)this.btnSetDir, gbc);
        this.btnSetDir.setFocusable(false);
        this.btnSetDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RaftsControlPanel.this.setImageDir();
            }
        });
        ++gbc.gridy;
        this.imgPanel.add((Component)this.btnSaveRaw, gbc);
        this.btnSaveRaw.setFocusable(false);
        this.btnSaveRaw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RaftsControlPanel.this.saveImage("saveImage");
            }
        });
        ++gbc.gridy;
        this.imgPanel.add((Component)this.btnSaveFits, gbc);
        this.btnSaveFits.setFocusable(false);
        this.btnSaveFits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RaftsControlPanel.this.saveImage("saveFitsImage");
            }
        });
    }

    private void initSubMainPanel() {
        this.subMainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 10);
        this.subMainPanel.add((Component)this.cfgPanel, gbc);
        ++gbc.gridx;
        gbc.insets.left = 10;
        this.subMainPanel.add((Component)this.setPanel, gbc);
        ++gbc.gridx;
        this.subMainPanel.add((Component)this.seqPanel, gbc);
        ++gbc.gridx;
        gbc.insets.right = 0;
        this.subMainPanel.add((Component)this.imgPanel, gbc);
    }

    private void initMessagePanel() {
        TitledBorder border = new TitledBorder("Messages");
        border.setTitleJustification(2);
        this.msgPanel.setBorder(border);
        this.msgPanel.add(this.spMessage);
        this.spMessage.setMinimumSize(this.spMessage.getPreferredSize());
        this.taMessage.setEditable(false);
    }

    private void initMainPanel() {
        this.mainPanel.setBorder(new TitledBorder(""));
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.insets = new Insets(10, 10, 5, 10);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.mainPanel.add((Component)this.raftsStPanel, gbc);
        gbc.insets.top = 0;
        gbc.insets.bottom = 10;
        ++gbc.gridy;
        this.mainPanel.add((Component)this.rebStPanel, gbc);
        gbc.insets.top = 10;
        ++gbc.gridy;
        this.mainPanel.add((Component)this.subMainPanel, gbc);
        ++gbc.gridy;
        this.mainPanel.add((Component)this.msgPanel, gbc);
    }

    private void initTopPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        this.add(this.mainPanel, gbc);
    }

    private void cfgREB(ActionEvent e) {
        for (int id = 0; id < this.rebNames.size(); ++id) {
            if (!e.getSource().equals(this.btnCfgREB[id])) continue;
            String name = this.rebNames.get(id);
            REBConfigPanel.edit(SwingUtilities.getWindowAncestor((Component)((Object)this)), name, this);
            return;
        }
    }

    private String getResult(List<Integer> masks) {
        if (masks == null) {
            return "check not done";
        }
        int sum = 0;
        for (int mask : masks) {
            sum |= mask;
        }
        if (sum == 0) {
            return "no errors";
        }
        StringBuilder result = new StringBuilder("mismatches =");
        for (int mask : masks) {
            result.append(String.format(" %08x", mask));
        }
        return result.toString();
    }

    private void seqLoad() {
        String fn;
        JFileChooser fc = new JFileChooser("./");
        fc.setFileFilter(new FileNameExtensionFilter(null, "xml", "seq", "sif"));
        if (fc.showOpenDialog(this.getTopFrame()) != 0) {
            return;
        }
        try {
            fn = fc.getSelectedFile().getCanonicalPath();
        }
        catch (IOException e) {
            this.displayError(e.toString());
            return;
        }
        List nSlice = (List)this.sendCommand(null, "loadSequencer", fn);
        if (nSlice != null) {
            StringBuilder msg = new StringBuilder("Slice counts = ");
            boolean first = true;
            Iterator iterator = nSlice.iterator();
            while (iterator.hasNext()) {
                int count = (Integer)iterator.next();
                msg.append(first ? "" : ", ").append(count);
                first = false;
            }
            this.display(msg.toString());
        }
    }

    private void setBackBiasCB() {
        boolean on;
        List values = (List)this.sendCommand(null, "isBackBiasOn", new Object[0]);
        boolean bl = on = values != null;
        if (on) {
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                boolean val = (Boolean)iterator.next();
                if (val) continue;
                on = false;
            }
        }
        this.cbxBackBias.setSelected(on);
    }

    private void setScanModeCB() {
        boolean scanMode;
        List values = (List)this.sendCommand(null, "isScanEnabled", new Object[0]);
        boolean bl = scanMode = values != null;
        if (scanMode) {
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                boolean val = (Boolean)iterator.next();
                if (val) continue;
                scanMode = false;
            }
        }
        this.cbxScanMode.setSelected(scanMode);
    }

    private void setPatternCB() {
        boolean pattern;
        List values = (List)this.sendCommand(null, "getDataSource", new Object[0]);
        boolean bl = pattern = values != null;
        if (pattern) {
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                int val = (Integer)iterator.next();
                if ((val & 1) != 0) continue;
                pattern = false;
            }
        }
        this.cbxPattern.setSelected(pattern);
    }

    private void setImageDir() {
        JFileChooser fc = new JFileChooser(this.imageDir == null ? "./" : this.imageDir);
        fc.setFileSelectionMode(1);
        if (fc.showOpenDialog(this.getTopFrame()) == 0) {
            this.imageDir = fc.getSelectedFile().getPath();
        }
    }

    private void saveImage(String cmnd) {
        if (this.imageDir != null) {
            List names = (List)this.sendCommand(null, cmnd, this.imageDir);
            if (names != null) {
                this.display("The following files were created:");
                for (String name : names) {
                    this.display("  " + name);
                }
            }
        } else {
            this.displayError("Image directory hasn't been set");
        }
    }

    private void updateConfig() {
        if (this.rebNames.size() != this.btnCfgREB.length) {
            this.cfgPanel.removeAll();
            this.initConfigPanel();
        } else {
            for (int j = 0; j < this.btnCfgREB.length; ++j) {
                this.btnCfgREB[j].setName(this.rebNames.get(j) + "...");
            }
        }
    }

    private void updateSetup() {
        this.setBackBiasCB();
    }

    private Object sendSubsysCommand(String subsys, String child, String name, Object ... params) {
        try {
            return this.gui.sendCommandRaw(subsys, child, name, params);
        }
        catch (Exception e) {
            this.log.error((Object)"Command error: ", (Throwable)e);
            String text = e.getMessage();
            this.displayError(text == null || text.isEmpty() ? e.toString() : text);
            return null;
        }
    }

    private Component getTopFrame() {
        Object c = this;
        while (!(c instanceof JFrame || c instanceof JWindow || c instanceof JDialog || ((Component)c).getParent() == null)) {
            c = ((Component)c).getParent();
        }
        return c;
    }

    private void updateMessage(String msg) {
        SwingUtilities.invokeLater(new UpdateMessage(msg));
    }

    private void displayError(String message) {
        this.taMessage.append(message + LF);
    }

    public void enableSystem(String name, int id) {
        if (id == 0) {
            this.rafts = name;
            SwingUtilities.invokeLater(new UpdateStatus());
            SwingUtilities.invokeLater(() -> this.enableButtons(true));
        }
    }

    public void disableSystem(String name, int id) {
        if (id == 0) {
            this.rafts = null;
            SwingUtilities.invokeLater(new UpdateStatus());
            SwingUtilities.invokeLater(() -> this.enableButtons(false));
        }
    }

    public void handleStatusData(String name, int id, long time, String key, Object d) {
        if (id == 0 && key.equals("ImageState")) {
            ImageState is = (ImageState)((KeyValueData)d).getValue();
            String message = String.format("Received image: timestamp = %016x, length = %s", is.getTimestamp(), is.getLength());
            this.updateMessage(message);
        }
    }

    private void enableButtons(boolean enable) {
        for (JButton b : this.btnCfgREB) {
            b.setEnabled(enable);
        }
        this.btnCfgSave.setEnabled(enable);
        this.btnLoadDacs.setEnabled(enable);
        this.btnLoadAspics.setEnabled(enable);
        this.btnLoadCabacs.setEnabled(enable);
        this.cbxBackBias.setEnabled(enable);
        this.btnSeqLoad.setEnabled(enable);
        this.btnSeqStart.setEnabled(enable);
        this.btnSeqStop.setEnabled(enable);
        this.btnSeqStep.setEnabled(enable);
        this.cbxScanMode.setEnabled(enable);
        this.btnResetScan.setEnabled(enable);
        this.cbxPattern.setEnabled(enable);
        this.btnResetFE.setEnabled(enable);
        this.btnAcquire.setEnabled(enable);
        this.btnSaveRaw.setEnabled(enable);
        this.btnSaveFits.setEnabled(enable);
    }

    class UpdateMessage
    implements Runnable {
        String message;

        UpdateMessage(String message) {
            this.message = message;
        }

        @Override
        public void run() {
            RaftsControlPanel.this.display(this.message);
        }
    }

    class UpdateStatus
    implements Runnable {
        UpdateStatus() {
        }

        @Override
        public void run() {
            if (RaftsControlPanel.this.rafts != null) {
                RaftsControlPanel.this.lblStValue.setText("RUNNING");
                RaftsControlPanel.this.lblStValue.setForeground(GREEN);
                RaftsControlPanel.this.rebNames = (List)RaftsControlPanel.this.sendCommand(null, "getREBDeviceNames", new Object[0]);
                StringBuilder text = new StringBuilder();
                for (String name : RaftsControlPanel.this.rebNames) {
                    text.append(" ").append(name);
                }
                RaftsControlPanel.this.lblRebs.setText(text.toString());
                RaftsControlPanel.this.updateConfig();
                RaftsControlPanel.this.updateSetup();
                RaftsControlPanel.this.setPatternCB();
                RaftsControlPanel.this.setScanModeCB();
            } else {
                RaftsControlPanel.this.lblStValue.setText("STOPPED");
                RaftsControlPanel.this.lblStValue.setForeground(RED);
            }
        }
    }
}

