/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.fpga.compiler;

import java.util.List;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.EmbeddedSubroutine;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.ModelBuilderVisitor;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Call;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Callable;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Channel;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Function;
import org.lsst.ccs.subsystem.rafts.fpga.xml.FunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Main;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Parameter;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatFunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatSubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Sequencer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Subroutine;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Timeslice;

class FPGA2ModelBuilderVisitor
extends ModelBuilderVisitor {
    private final FPGA2Model model = new FPGA2Model();
    private int nMains = 0;
    int curFuncIndex = 0;
    int nextFuncIndex = 1;
    int curFuncPtrIndex = 0;
    int curSubPtrIndex = 0;
    int curRepFuncPtrIndex = 0;
    int curRepSubPtrIndex = 0;

    FPGA2ModelBuilderVisitor() {
    }

    public FPGA2Model getModel() {
        return this.model;
    }

    @Override
    public void visit(Function f) {
        this.curFuncIndex = f.getId().equals("Default") ? 0 : this.nextFuncIndex++;
        this.model.functionsMap.put(f, this.curFuncIndex);
        super.visit(f);
        if (this.sliceIndex < 16) {
            FPGA2Model.EndSliceTime t = new FPGA2Model.EndSliceTime(this.curFuncIndex, f, this.sliceIndex);
            this.model.timing.put(t.getAddress(), t);
        }
    }

    @Override
    public void visit(Timeslice s) {
        super.visit(s);
        FPGA2Model.SliceValues v = new FPGA2Model.SliceValues(this.curFuncIndex, (Function)this.current, s);
        this.model.timing.put(v.getAddress(), v);
        FPGA2Model.SliceTime t = new FPGA2Model.SliceTime(this.curFuncIndex, (Function)this.current, s);
        this.model.timing.put(t.getAddress(), t);
    }

    @Override
    public void visit(Subroutine s) {
        super.visit(s);
        FPGA2Model.FPGARoutine r = this.buildRoutine(s);
        this.model.routines.add(r);
        this.model.routinesMap.put(s, r);
    }

    @Override
    public void visit(Main m) {
        super.visit(m);
        FPGA2Model.FPGARoutine r = this.buildRoutine(m);
        this.model.routines.add(this.nMains++, r);
        this.model.routinesMap.put(m, r);
    }

    @Override
    public void visit(FunctionPointer fp) {
        this.model.functionsPtrMap.put(fp, this.curFuncPtrIndex);
        ++this.curFuncPtrIndex;
        super.visit(fp);
    }

    @Override
    public void visit(SubroutinePointer sp) {
        this.model.routinesPtrMap.put(sp, this.curSubPtrIndex);
        ++this.curSubPtrIndex;
        super.visit(sp);
    }

    @Override
    public void visit(RepeatFunctionPointer rfp) {
        this.model.functionsRepPtrMap.put(rfp, this.curRepFuncPtrIndex);
        ++this.curRepFuncPtrIndex;
        super.visit(rfp);
    }

    @Override
    public void visit(RepeatSubroutinePointer rsp) {
        this.model.routinesRepPtrMap.put(rsp, this.curRepSubPtrIndex);
        ++this.curRepSubPtrIndex;
        super.visit(rsp);
    }

    private FPGA2Model.FPGARoutine buildRoutine(Callable c) {
        List<Call> calls;
        FPGA2Model.FPGARoutine r = new FPGA2Model.FPGARoutine();
        r.orgRoutine = c;
        if (c instanceof Subroutine) {
            calls = ((Subroutine)c).getCalls();
        } else if (c instanceof EmbeddedSubroutine) {
            calls = ((EmbeddedSubroutine)c).getCalls();
        } else {
            throw new RuntimeException("type mismatch for " + c + " should be Subroutine or Embedded");
        }
        calls.stream().forEach(call -> {
            if (call.getFunction() != null) {
                if (call.getRepeatFcnPtr() == null) {
                    FPGA2Model fPGA2Model = this.model;
                    fPGA2Model.getClass();
                    FPGA2Model.StackFunctionOpCode op = fPGA2Model.new FPGA2Model.StackFunctionOpCode((Call)call, r);
                    r.add(op);
                } else {
                    FPGA2Model fPGA2Model = this.model;
                    fPGA2Model.getClass();
                    FPGA2Model.StackFunctionRepPtrOpCode op = fPGA2Model.new FPGA2Model.StackFunctionRepPtrOpCode((Call)call, r);
                    r.add(op);
                }
            } else if (call.getFunctionPointer() != null) {
                if (call.getRepeatFcnPtr() == null) {
                    FPGA2Model fPGA2Model = this.model;
                    fPGA2Model.getClass();
                    FPGA2Model.StackFunctionPtrOpCode op = fPGA2Model.new FPGA2Model.StackFunctionPtrOpCode((Call)call, r);
                    r.add(op);
                } else {
                    FPGA2Model fPGA2Model = this.model;
                    fPGA2Model.getClass();
                    FPGA2Model.StackFunctionPtrRepPtrOpCode op = fPGA2Model.new FPGA2Model.StackFunctionPtrRepPtrOpCode((Call)call, r);
                    r.add(op);
                }
            } else if (call.getSubroutine() != null) {
                if (call.getRepeatSubPtr() == null) {
                    FPGA2Model.StackSubroutineOpCode op = new FPGA2Model.StackSubroutineOpCode((Call)call, r, null);
                    r.add(op);
                } else {
                    FPGA2Model fPGA2Model = this.model;
                    fPGA2Model.getClass();
                    FPGA2Model.StackSubroutineRepPtrOpCode op = fPGA2Model.new FPGA2Model.StackSubroutineRepPtrOpCode((Call)call, r, null);
                    r.add(op);
                }
            } else if (call.getSubroutinePointer() != null) {
                if (call.getRepeatSubPtr() == null) {
                    FPGA2Model fPGA2Model = this.model;
                    fPGA2Model.getClass();
                    FPGA2Model.StackSubroutinePtrOpCode op = fPGA2Model.new FPGA2Model.StackSubroutinePtrOpCode((Call)call, r);
                    r.add(op);
                } else {
                    FPGA2Model fPGA2Model = this.model;
                    fPGA2Model.getClass();
                    FPGA2Model.StackSubroutinePtrRepPtrOpCode op = fPGA2Model.new FPGA2Model.StackSubroutinePtrRepPtrOpCode((Call)call, r);
                    r.add(op);
                }
            } else {
                Subroutine parent = c instanceof Subroutine ? (Subroutine)c : ((EmbeddedSubroutine)c).getParent();
                EmbeddedSubroutine es = new EmbeddedSubroutine(parent);
                es.setCalls(call.getCalls());
                FPGA2Model.FPGARoutine er = this.buildRoutine(es);
                this.model.routines.add(er);
                if (call.getRepeatSubPtr() == null) {
                    FPGA2Model.StackSubroutineOpCode op = new FPGA2Model.StackSubroutineOpCode((Call)call, r, er);
                    r.add(op);
                } else {
                    FPGA2Model fPGA2Model = this.model;
                    fPGA2Model.getClass();
                    FPGA2Model.StackSubroutineRepPtrOpCode op = fPGA2Model.new FPGA2Model.StackSubroutineRepPtrOpCode((Call)call, r, er);
                    r.add(op);
                }
            }
        });
        r.add(new FPGA2Model.StackReturnOpcode(r));
        return r;
    }

    private void completeRoutines() {
        this.model.routines.stream().forEach(r -> r.opcodes.stream().forEach(op -> {
            if (op instanceof FPGA2Model.StackSubroutineOpCode) {
                FPGA2Model.StackSubroutineOpCode sop = (FPGA2Model.StackSubroutineOpCode)op;
                if (sop.callee == null) {
                    FPGA2Model.FPGARoutine rr;
                    sop.callee = rr = this.model.routinesMap.get(sop.call.getSubroutine());
                }
            } else if (op instanceof FPGA2Model.StackSubroutineRepPtrOpCode) {
                FPGA2Model.StackSubroutineRepPtrOpCode sop = (FPGA2Model.StackSubroutineRepPtrOpCode)op;
                if (sop.callee == null) {
                    FPGA2Model.FPGARoutine rr;
                    sop.callee = rr = this.model.routinesMap.get(sop.call.getSubroutine());
                }
            }
        }));
        int addr = 0;
        for (FPGA2Model.FPGARoutine r2 : this.model.routines) {
            r2.baseAddress = addr;
            addr += r2.opcodes.size();
            addr = (addr + 16) / 16 * 16;
        }
        this.model.lastAddr = addr - 1;
    }

    @Override
    public void visit(Sequencer s) {
        super.visit(s);
        this.completeRoutines();
        this.updateMetadata(s);
        this.updateChannels(s);
    }

    private void updateMetadata(Sequencer s) {
        List<Parameter> params = s.getSequencerConfig().getParameters();
        params.stream().forEach(p -> this.model.addMetadata(p.getId(), p.getValue()));
    }

    private void updateChannels(Sequencer s) {
        List<Channel> channels = s.getSequencerConfig().getChannels();
        channels.stream().forEach(c -> this.model.addChannel(c.getId(), c.getValue()));
    }
}

