/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.awt.Color;
import java.util.EnumSet;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;

public class TracerMessage
implements FilteredMessage {
    private BusMessage busMessage;
    private String message;
    private EnumSet<FilteredMessage.Flag> actions;
    private Color color;

    public TracerMessage(BusMessage busMessage) {
        this.busMessage = busMessage;
    }

    public TracerMessage(FilteredMessage filteredMessage) {
        this.busMessage = filteredMessage.getBusMessage();
        this.message = filteredMessage.getMessage();
        EnumSet<FilteredMessage.Flag> as = filteredMessage.getFlags();
        this.actions = as == null || as.isEmpty() ? null : EnumSet.copyOf(as);
        this.color = filteredMessage.getColor();
    }

    @Override
    public BusMessage getBusMessage() {
        return this.busMessage;
    }

    @Override
    public BusMessage setBusMessage(BusMessage busMessage) {
        BusMessage old = this.busMessage;
        this.busMessage = busMessage;
        return old;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String setMessage(String message) {
        String old = this.message;
        this.message = message;
        return old;
    }

    @Override
    public EnumSet<FilteredMessage.Flag> getFlags() {
        return this.actions;
    }

    @Override
    public void addFlag(FilteredMessage.Flag action, FilteredMessage.Flag ... moreActions) {
        if (this.actions == null) {
            this.actions = EnumSet.of(action, moreActions);
        } else {
            this.actions.add(action);
            for (FilteredMessage.Flag a : moreActions) {
                this.actions.add(a);
            }
        }
    }

    @Override
    public void clearFlags() {
        this.actions = null;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Color setColor(Color color) {
        Color old = this.color;
        this.color = color;
        return old;
    }
}

