/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.dictionary;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.gconsole.plugins.dictionary.AgentDictionaries;
import org.lsst.ccs.gconsole.plugins.dictionary.AgentDictionaryTable;
import org.lsst.ccs.gconsole.plugins.dictionary.ArgInputPanel;
import org.lsst.ccs.gconsole.plugins.dictionary.CommandListPanel;
import org.lsst.ccs.gconsole.plugins.dictionary.ComponentDictionary;
import org.lsst.ccs.gconsole.plugins.dictionary.DictionaryTreePanel;
import org.lsst.ccs.gconsole.plugins.dictionary.HTMLTextPane;
import org.lsst.ccs.gconsole.plugins.dictionary.HintTextField;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.logging.StackTraceFormats;
import org.lsst.ccs.utilities.structs.TreeBranch;

public class DictionaryTreeMainPanel
extends JPanel
implements ListSelectionListener,
AgentPresenceListener,
ActionListener,
AgentLockService.AgentLockUpdateListener,
AgentLockService.AgentLevelListener {
    private final Logger logger = Logger.getLogger((String)"org.lsst.ccs.plugin.jas3.dictionary");
    private final AgentMessagingLayer messagingAccess;
    private final AgentLockService agentLockService;
    private CommandListPanel commandListPanel;
    private final AgentDictionaryTable agentTable;
    private final DictionaryTreePanel dictionaryTree;
    private final ArgInputPanel argInputPanel;
    private final HTMLTextPane resultPane;

    DictionaryTreeMainPanel(AgentMessagingLayer messagingAccess, RouteSelectionCommandSet rsc, AgentLockService als) {
        super(new BorderLayout());
        this.messagingAccess = messagingAccess;
        this.agentLockService = als;
        this.agentTable = new AgentDictionaryTable(rsc);
        this.agentTable.getSelectionModel().addListSelectionListener(this);
        this.dictionaryTree = new DictionaryTreePanel();
        JScrollPane agentsView = new JScrollPane(this.agentTable);
        this.agentTable.setFillsViewportHeight(true);
        JScrollPane treeView = new JScrollPane(this.dictionaryTree);
        this.commandListPanel = new CommandListPanel();
        this.dictionaryTree.addTreeSelectionListener(this.commandListPanel);
        this.commandListPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DictionaryCommand cmd;
                if (e.getClickCount() == 2 && (cmd = (DictionaryCommand)DictionaryTreeMainPanel.this.commandListPanel.getSelectedValue()).getArguments().length == 0) {
                    DictionaryTreeMainPanel.this.sendCommand();
                }
            }
        });
        JScrollPane cmdListView = new JScrollPane(this.commandListPanel);
        JPanel topPane = new JPanel(new GridLayout(1, 3));
        JPanel leftPane = new JPanel(new BorderLayout());
        leftPane.setPreferredSize(new Dimension(300, 800));
        URL url = this.getClass().getResource("refresh_24dp.png");
        JButton refreshAgentsButton = new JButton();
        refreshAgentsButton.setIcon(new ImageIcon(url));
        refreshAgentsButton.setToolTipText("Refresh");
        refreshAgentsButton.addActionListener(this);
        JCheckBox[] checkBoxArray = new JCheckBox[AgentInfo.AgentType.values().length];
        JPanel checkBoxPanel = new JPanel(new GridLayout(4, 2));
        for (AgentInfo.AgentType type : AgentInfo.AgentType.values()) {
            checkBoxArray[type.ordinal()] = new JCheckBox(type.displayName());
            checkBoxArray[type.ordinal()].addItemListener(this.agentTable);
            checkBoxArray[type.ordinal()].setName(type.toString());
            checkBoxPanel.add(checkBoxArray[type.ordinal()]);
        }
        JPanel leftPanelBottom = new JPanel(new BorderLayout());
        leftPanelBottom.add((Component)new ConsoleBuiltInsPanel(), "North");
        leftPanelBottom.add((Component)checkBoxPanel, "Center");
        leftPanelBottom.add((Component)refreshAgentsButton, "South");
        leftPane.add((Component)agentsView, "Center");
        leftPane.add((Component)leftPanelBottom, "South");
        this.add((Component)leftPane, "West");
        topPane.add(treeView);
        topPane.add(cmdListView);
        this.argInputPanel = new ArgInputPanel();
        this.commandListPanel.addListSelectionListener(this.argInputPanel);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        JButton sendCmdButton = new JButton(new ImageIcon(this.getClass().getResource("ic_send_black_24dp.png")));
        sendCmdButton.setText("Send");
        sendCmdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DictionaryTreeMainPanel.this.sendCommand();
            }
        });
        buttonPane.add(sendCmdButton);
        this.add((Component)buttonPane, "South");
        JPanel topPaneRightPanel = new JPanel(new BorderLayout());
        topPaneRightPanel.add((Component)this.argInputPanel, "Center");
        topPaneRightPanel.add((Component)buttonPane, "South");
        topPane.add(topPaneRightPanel);
        this.resultPane = new HTMLTextPane();
        JScrollPane resultPaneView = new JScrollPane(this.resultPane);
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(topPane);
        splitPane.setBottomComponent(resultPaneView);
        splitPane.setContinuousLayout(true);
        this.add((Component)splitPane, "Center");
        checkBoxArray[AgentInfo.AgentType.WORKER.ordinal()].setSelected(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.dictionaryTree.setModel(new DefaultTreeModel(null));
        this.argInputPanel.clearForm();
        AgentDictionaries dict = this.agentTable.getSelectedAgentDictionaries();
        if (dict != null) {
            this.dictionaryTree.updateData(dict);
        }
    }

    public void connecting(AgentInfo agent) {
        SwingUtilities.invokeLater(() -> {
            this.agentTable.addAgentToList(agent);
            this.agentTable.updateLockForAgent(agent.getName(), this.agentLockService.getLockForAgent(agent.getName()) != null);
            this.agentTable.updateLevelForAgent(agent.getName(), this.agentLockService.getLevelForAgent(agent.getName()));
        });
    }

    public void disconnecting(AgentInfo agent) {
        this.agentTable.removeAgentFromList(agent);
    }

    public void sendCommand() {
        TreeBranch destinationNode = (TreeBranch)this.dictionaryTree.getLastSelectedPathComponent();
        ComponentDictionary commandContext = (ComponentDictionary)destinationNode.getContent();
        String s = " ";
        DictionaryCommand cmd = (DictionaryCommand)this.commandListPanel.getSelectedValue();
        if (cmd != null) {
            s = s + this.argInputPanel.getFormattedArgumentValues();
            new SendCommandWorker(cmd.getCommandName() + s, commandContext.commandSet, commandContext.path).execute();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new SwingWorker<List<AgentInfo>, String>(){

            @Override
            protected List<AgentInfo> doInBackground() throws Exception {
                return DictionaryTreeMainPanel.this.messagingAccess.getAgentPresenceManager().listConnectedAgents();
            }

            @Override
            public void done() {
                try {
                    List agentInfos = (List)this.get();
                    DictionaryTreeMainPanel.this.agentTable.updateAgentsList(agentInfos);
                }
                catch (Exception ex) {
                    DictionaryTreeMainPanel.this.logger.error((Object)ex);
                }
            }
        }.execute();
    }

    public void onAgentLockUpdate(String agentName, AgentLock lock) {
        this.agentTable.updateLockForAgent(agentName, this.agentLockService.getLockForAgent(agentName) != null);
        this.commandListPanel.updateRenderer();
        this.dictionaryTree.updateRenderer();
    }

    public void onAgentLevelChange(String agentName, int level) {
        this.agentTable.updateLevelForAgent(agentName, level);
        this.commandListPanel.updateRenderer();
        this.dictionaryTree.updateRenderer();
    }

    private class ConsoleBuiltInsPanel
    extends JPanel {
        private final JButton setLevelButton;
        private final JButton unlockButton;
        private final JButton lockButton;
        private final HintTextField levelInputTF;

        ConsoleBuiltInsPanel() {
            super(new GridLayout(2, 2));
            this.setLevelButton = new JButton("setLevel");
            this.unlockButton = new JButton("Unlock");
            this.lockButton = new JButton("Lock");
            this.levelInputTF = new HintTextField("level");
            this.add(this.lockButton);
            this.add(this.unlockButton);
            this.add(this.levelInputTF);
            this.add(this.setLevelButton);
            this.setLevelButton.addActionListener(e -> {
                try {
                    AgentDictionaries dc = DictionaryTreeMainPanel.this.agentTable.getSelectedAgentDictionaries();
                    if (dc == null) {
                        return;
                    }
                    String selectedAgentName = dc.ai.getName();
                    int level = Integer.valueOf(this.levelInputTF.getText());
                    DictionaryTreeMainPanel.this.agentLockService.setLevelForAgent(selectedAgentName, level);
                    this.levelInputTF.setHint();
                }
                catch (NumberFormatException dc) {
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage());
                }
            });
            this.lockButton.addActionListener(e -> {
                try {
                    AgentDictionaries dc = DictionaryTreeMainPanel.this.agentTable.getSelectedAgentDictionaries();
                    if (dc == null) {
                        return;
                    }
                    String selectedAgentName = dc.ai.getName();
                    DictionaryTreeMainPanel.this.agentLockService.lockAgent(selectedAgentName);
                    this.levelInputTF.setHint();
                }
                catch (NumberFormatException dc) {
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage());
                }
            });
            this.unlockButton.addActionListener(e -> {
                try {
                    AgentDictionaries dc = DictionaryTreeMainPanel.this.agentTable.getSelectedAgentDictionaries();
                    if (dc == null) {
                        return;
                    }
                    String selectedAgentName = dc.ai.getName();
                    DictionaryTreeMainPanel.this.agentLockService.unlockAgent(selectedAgentName);
                    this.levelInputTF.setHint();
                }
                catch (NumberFormatException dc) {
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage());
                }
            });
        }
    }

    public class SendCommandWorker
    extends SwingWorker<String, String> {
        private final String cmd;
        private final CommandSet destination;
        private final String path;

        public SendCommandWorker(String cmdName, CommandSet dest, String path) {
            this.cmd = cmdName;
            this.destination = dest;
            this.path = path;
        }

        @Override
        protected String doInBackground() throws Exception {
            DictionaryTreeMainPanel.this.resultPane.insertHTML("invoke " + this.path + " " + this.cmd + " ...");
            try {
                Object res = this.destination.invoke((BasicCommand)new TokenizedCommand(this.cmd));
                String strRes = null;
                strRes = res instanceof Exception ? StackTraceFormats.toString((Throwable)((Exception)res), (int)1) : (res == null ? "ok : VOID" : String.valueOf(res));
                return strRes;
            }
            catch (Exception e) {
                return "<html> <font color=\"#FF0000\"> Exception caught : " + StackTraceFormats.toString((Throwable)e, (int)1) + "</font></html>";
            }
        }

        @Override
        public void done() {
            try {
                String result = (String)this.get();
                DictionaryTreeMainPanel.this.resultPane.insertHTML(result);
            }
            catch (InterruptedException ex) {
                DictionaryTreeMainPanel.this.logger.error((Object)ex);
            }
            catch (ExecutionException ex) {
                DictionaryTreeMainPanel.this.logger.error((Object)ex);
            }
        }
    }
}

