/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.dictionary;

import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.gconsole.plugins.dictionary.ComponentDictionary;
import org.lsst.ccs.utilities.structs.TreeBranch;

public class CommandListPanel
extends JList<DictionaryCommand>
implements TreeSelectionListener,
ListSelectionListener {
    private final SortedListModel cmdListModel = new SortedListModel();
    private final CommandListRenderer renderer;
    private Dictionary currentDictionary;

    public CommandListPanel() {
        this.setModel(this.cmdListModel);
        this.getSelectionModel().setSelectionMode(0);
        this.renderer = new CommandListRenderer();
        this.setCellRenderer(this.renderer);
    }

    @Override
    public void valueChanged(TreeSelectionEvent tse) {
        TreeBranch node = (TreeBranch)((JTree)tse.getSource()).getLastSelectedPathComponent();
        this.cmdListModel.clear();
        if (node == null) {
            return;
        }
        this.currentDictionary = ((ComponentDictionary)node.getContent()).dictionary;
        if (this.currentDictionary == null) {
            return;
        }
        for (DictionaryCommand dc : this.currentDictionary) {
            this.cmdListModel.add(dc);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.cmdListModel.clear();
    }

    public void updateRenderer() {
        if (this.currentDictionary != null) {
            this.cmdListModel.clear();
            for (DictionaryCommand dc : this.currentDictionary) {
                this.cmdListModel.add(dc);
            }
            this.revalidate();
            this.repaint();
        }
    }

    private boolean isCommandVisible(DictionaryCommand command) {
        if (this.currentDictionary != null) {
            return this.currentDictionary.getLevel() >= command.getLevel() && this.currentDictionary.getVisibilityForType(command.getType());
        }
        return true;
    }

    private class SortedListModel
    extends AbstractListModel {
        SortedSet<DictionaryCommand> model;

        SortedListModel() {
            this.model = new TreeSet<DictionaryCommand>(new Comparator<DictionaryCommand>(){

                @Override
                public int compare(DictionaryCommand o1, DictionaryCommand o2) {
                    if (CommandListPanel.this.isCommandVisible(o2) != CommandListPanel.this.isCommandVisible(o1)) {
                        if (CommandListPanel.this.isCommandVisible(o1)) {
                            return -1;
                        }
                        return 1;
                    }
                    return o1.getCommandName().compareTo(o2.getCommandName());
                }
            });
        }

        @Override
        public int getSize() {
            return this.model.size();
        }

        @Override
        public DictionaryCommand getElementAt(int index) {
            return (DictionaryCommand)this.model.toArray()[index];
        }

        public void add(DictionaryCommand element) {
            if (this.model.add(element)) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
        }

        public void addAll(DictionaryCommand[] elements) {
            List<DictionaryCommand> c = Arrays.asList(elements);
            this.model.addAll(c);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void clear() {
            CommandListPanel.this.clearSelection();
            this.model.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public boolean contains(DictionaryCommand element) {
            return this.model.contains(element);
        }

        public Object firstElement() {
            return this.model.first();
        }

        public Iterator iterator() {
            return this.model.iterator();
        }

        public Object lastElement() {
            return this.model.last();
        }

        public boolean removeElement(DictionaryCommand element) {
            boolean removed = this.model.remove(element);
            if (removed) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
            return removed;
        }
    }

    private class CommandListRenderer
    extends DefaultListCellRenderer {
        private CommandListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jlist, Object e, int i, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(jlist, e, i, isSelected, cellHasFocus);
            DictionaryCommand dc = (DictionaryCommand)e;
            this.setText(dc.getCommandName());
            if (!CommandListPanel.this.isCommandVisible(dc)) {
                this.setForeground(Color.GRAY);
            }
            return this;
        }
    }
}

