/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.demo.monitor;

import java.awt.Component;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.plugins.demo.monitor.TradMonitorGui;
import org.lsst.ccs.messaging.AgentPresenceListener;

public class TradStylePlugin
extends ConsolePlugin {
    private final List<String> monitoredSubsystems = Arrays.asList("demo-subsystem-with-monitoring", "monitor-test");
    private final Map<String, TradMonitorGui> mapOfMonitorGuis = new HashMap<String, TradMonitorGui>();

    @Override
    public void initialize() {
        this.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(new AgentPresenceListener(){

            public void connecting(AgentInfo agent) {
                String name = agent.getName();
                if (TradStylePlugin.this.monitoredSubsystems.contains(name)) {
                    SwingUtilities.invokeLater(() -> {
                        if (TradStylePlugin.this.mapOfMonitorGuis.get(agent.getName()) == null) {
                            TradStylePlugin.this.mapOfMonitorGuis.put(agent.getName(), TradStylePlugin.openMonitorGui(name, TradStylePlugin.this.getConsole()));
                        }
                    });
                }
            }

            public void disconnecting(AgentInfo agent) {
            }
        });
    }

    private static TradMonitorGui openMonitorGui(String agentName, Console console) {
        TradMonitorGui gui = new TradMonitorGui(agentName);
        String title = agentName.replace("ccs-", "").replace("ccs", "").toUpperCase() + " Monitor";
        console.getPanelManager().open((Component)gui.getGuiLayout(), title);
        gui.initGui();
        return gui;
    }
}

