/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentMBeanService;
import org.lsst.ccs.services.AgentMonitor;
import org.lsst.ccs.services.AgentMonitorServiceMBean;

public class AgentMonitorService
implements AgentMonitorServiceMBean,
Runnable,
HasLifecycle {
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.services.mbean");
    @LookupField(strategy=LookupField.Strategy.TREE)
    private List<AgentMonitor> monitors = new ArrayList<AgentMonitor>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentMBeanService mbeanService;
    public static final String AGENT_MONITOR_SERVICE_TASK = "agentMonitorSerive";
    private boolean registerMBean = true;
    private final Agent a;

    public AgentMonitorService(Agent a) {
        this.a = a;
        if (a.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0) {
            AgentPeriodicTask agentMonitorServiceTask = new AgentPeriodicTask(AGENT_MONITOR_SERVICE_TASK, this).withPeriod(Duration.ofMinutes(1L));
            a.getAgentPeriodicTaskService().scheduleAgentPeriodicTask(agentMonitorServiceTask);
            ComponentNode agentMonitorServiceComponentNode = new ComponentNode(a.getComponentLookup().getTopComponentNode(), "agentMonitorService", (Object)this);
            a.getComponentLookup().addComponentNodeToLookup(a.getComponentLookup().getTopComponentNode(), agentMonitorServiceComponentNode);
            this.registerMBean = false;
        }
    }

    @Override
    public void postInit() {
        try {
            if (this.mbeanService != null && this.registerMBean) {
                this.mbeanService.registerMBean(this, new ObjectName("org.lsst.ccs.mbean.agentMonitor:type=AgentMonitor"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        String status = this.getAgentStatus(true);
        if (!"OK".equals(status)) {
            this.log.warn((Object)status);
        }
    }

    @Override
    public String getAgentStatus() {
        return this.getAgentStatus(false);
    }

    private String getAgentStatus(boolean useCcsBuses) {
        if (this.monitors.isEmpty()) {
            this.log.debug((Object)"Nothing to monitor. No AgentMonitors are available");
        } else {
            StringBuilder overallStatus = new StringBuilder();
            for (AgentMonitor monitor : this.monitors) {
                String monitorStatus = monitor.getAgentMonitorStatus(useCcsBuses);
                this.log.debug((Object)("Checking " + monitor.getAgentMonitorDescription() + ": \n" + monitorStatus));
                if (monitorStatus.equals("OK")) continue;
                overallStatus.append(monitor.getAgentMonitorDescription()).append("\n").append(monitorStatus).append("\n");
            }
            String status = overallStatus.toString();
            if (!status.isEmpty()) {
                this.log.warn((Object)status);
                return status;
            }
        }
        return "OK";
    }
}

