/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;

@Entity
@Immutable
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"phaseState", "operationalState", "commandState", "alertState", "configState"})}, indexes={@Index(columnList="phaseState"), @Index(columnList="operationalState"), @Index(columnList="alertState"), @Index(columnList="commandState"), @Index(columnList="configState")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="org.lsst.ccs.localdb.statusdb.model.BaseState")
@NamedQueries(value={@NamedQuery(name="findBaseState", query="from BaseState bs where bs.alertState=:alertSt and bs.configState=:configurationSt and bs.commandState=:commandSt and bs.operationalState=:operationalSt and bs.phaseState=:phaseSt", hints={@QueryHint(name="org.hibernate.cacheable", value="true")})})
public class BaseState
implements Serializable {
    private static final String UNDEFINED_STATE = "__UNDEF__";
    private static final long serialVersionUID = -6550418264821719859L;
    private long id;
    private String alertState;
    private String configState;
    private String phaseState;
    private String commandState;
    private String operationalState;

    public BaseState() {
    }

    public BaseState(StateBundle sb) {
        this.alertState = BaseState.getStateString(sb.getState(AlertState.class));
        this.phaseState = BaseState.getStateString(sb.getState(PhaseState.class));
        this.commandState = BaseState.getStateString(sb.getState(CommandState.class));
        this.operationalState = BaseState.getStateString(sb.getState(OperationalState.class));
        this.configState = BaseState.getStateString(sb.getState(ConfigurationState.class));
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getAlertState() {
        return this.alertState;
    }

    public void setAlertState(String alertState) {
        this.alertState = alertState;
    }

    public String getConfigState() {
        return this.configState;
    }

    public void setConfigState(String configurationState) {
        this.configState = configurationState;
    }

    public String getPhaseState() {
        return this.phaseState;
    }

    public void setPhaseState(String phaseState) {
        this.phaseState = phaseState;
    }

    public String getCommandState() {
        return this.commandState;
    }

    public void setCommandState(String commandState) {
        this.commandState = commandState;
    }

    public String getOperationalState() {
        return this.operationalState;
    }

    public void setOperationalState(String operationalState) {
        this.operationalState = operationalState;
    }

    private static String getStateString(Enum state) {
        return state == null ? UNDEFINED_STATE : state.toString();
    }

    public String toString() {
        return "PhaseState:" + this.phaseState + ", OperationalState:" + this.operationalState + ",CommandState:" + this.commandState + ",AlertState:" + this.alertState + ",ConfigState:" + this.configState;
    }
}

