/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.fpga.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilder;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilderTest;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelUtils;

public class FPGA2ModelUtilsTest {
    @Test
    public void testUtils() throws IOException {
        try (InputStream input = FPGA2ModelBuilderTest.class.getResourceAsStream("sequencer-reb3.seq");){
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            FPGA2Model compiled = builder.compileFile(input);
            FPGA2ModelUtils utils = new FPGA2ModelUtils(compiled, Collections.EMPTY_MAP);
            FPGA2ModelUtils.LongWithInfinity clockCycles = utils.getClockCyclesForRoutine("Exposure25ms");
            FPGA2ModelUtils.FloatWithInfinity nanos = clockCycles.times(compiled.getClockPeriod());
            Assert.assertEquals((long)2500000L, (long)clockCycles.getValue());
            Assert.assertEquals((double)2.5E7, (double)nanos.getValue().doubleValue(), (double)1.0E-5);
            FPGA2ModelUtils.LongWithInfinity clockCycles2 = utils.getClockCyclesForRoutine("Acquisition");
            FPGA2ModelUtils.FloatWithInfinity nanos2 = clockCycles2.times(compiled.getClockPeriod());
            Assert.assertEquals((long)643349232L, (long)clockCycles2.getValue());
            Assert.assertEquals((double)6.43349232E9, (double)nanos2.getValue().doubleValue(), (double)0.1);
            Assert.assertEquals((long)256000L, (long)utils.getPixelsForRoutine("Acquisition").getValue());
        }
    }

    @Test
    public void testUtils64() throws IOException {
        try (InputStream input = FPGA2ModelBuilderTest.class.getResourceAsStream("sequencer-reb3_64.seq");){
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            FPGA2Model compiled = builder.compileFile(input);
            FPGA2ModelUtils utils = new FPGA2ModelUtils(compiled, Collections.EMPTY_MAP);
            FPGA2ModelUtils.LongWithInfinity clockCycles = utils.getClockCyclesForRoutine("Exposure25ms");
            FPGA2ModelUtils.FloatWithInfinity nanos = clockCycles.times(compiled.getClockPeriod());
            Assert.assertEquals((long)3940000L, (long)clockCycles.getValue());
            Assert.assertEquals((double)2.5216E7, (double)nanos.getValue().doubleValue(), (double)1.0E-5);
            FPGA2ModelUtils.LongWithInfinity clockCycles2 = utils.getClockCyclesForRoutine("Acquisition");
            FPGA2ModelUtils.FloatWithInfinity nanos2 = clockCycles2.times(compiled.getClockPeriod());
            Assert.assertEquals((long)1014200880L, (long)clockCycles2.getValue());
            Assert.assertEquals((double)6.490885632E9, (double)nanos2.getValue().doubleValue(), (double)0.1);
            Assert.assertEquals((long)256000L, (long)utils.getPixelsForRoutine("Acquisition").getValue());
        }
    }

    @Test
    public void testUtilsWithParameters() throws IOException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("ReadCols", 64);
        parameters.put("Exposure", "SlowFlush");
        try (InputStream input = FPGA2ModelBuilderTest.class.getResourceAsStream("sequencer-reb3.seq");){
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            FPGA2Model compiled = builder.compileFile(input);
            FPGA2ModelUtils utils = new FPGA2ModelUtils(compiled, parameters);
            FPGA2ModelUtils.LongWithInfinity clockCycles = utils.getClockCyclesForRoutine("Exposure25ms");
            FPGA2ModelUtils.FloatWithInfinity nanos = clockCycles.times(compiled.getClockPeriod());
            Assert.assertEquals((long)200000000L, (long)clockCycles.getValue());
            Assert.assertEquals((double)2.0E9, (double)nanos.getValue().doubleValue(), (double)0.1);
            FPGA2ModelUtils.LongWithInfinity clockCycles2 = utils.getClockCyclesForRoutine("Acquisition");
            FPGA2ModelUtils.FloatWithInfinity nanos2 = clockCycles2.times(compiled.getClockPeriod());
            Assert.assertEquals((long)16407445232L, (long)clockCycles2.getValue());
            Assert.assertEquals((double)1.6407445232E11, (double)nanos2.getValue().doubleValue(), (double)0.1);
            Assert.assertEquals((long)64000L, (long)utils.getPixelsForRoutine("Acquisition").getValue());
        }
    }
}

