/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.fpga.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.CRC32;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilder;

public class FPGA2ModelBuilderTest {
    @Test
    public void textXMLCompile() throws IOException {
        try (InputStream input = FPGA2ModelBuilderTest.class.getResourceAsStream("seq_1M.xml");){
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            FPGA2Model compiled = builder.compileFile(input);
            Assert.assertEquals((Object)"1000000", (Object)compiled.getMetadata("nSlices"));
            Assert.assertEquals((Object)"500 ns", (Object)compiled.getMetadata("TimeP"));
            Map channels = compiled.getChannels();
            Assert.assertEquals((long)5L, (long)((Integer)channels.get("R2")).intValue());
            Assert.assertEquals((long)691908524L, (long)compiled.computeCheckSum());
        }
    }

    @Test
    public void textAssemblerCompile() throws IOException {
        try (InputStream input = FPGA2ModelBuilderTest.class.getResourceAsStream("seq_1M.seq");){
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            FPGA2Model compiled = builder.compileFile(input);
            Assert.assertEquals((Object)"1000000", (Object)compiled.getMetadata("Slices"));
            Assert.assertEquals((Object)"500 ns", (Object)compiled.getMetadata("TimeP"));
            Map channels = compiled.getChannels();
            Assert.assertEquals((long)10L, (long)((Integer)channels.get("P2")).intValue());
            Assert.assertEquals((long)1615944585L, (long)compiled.computeCheckSum());
        }
    }

    @Test
    public void testComplexAssemblerCompile() throws IOException {
        try (InputStream input = FPGA2ModelBuilderTest.class.getResourceAsStream("sequencer-reb3.seq");){
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            FPGA2Model compiled = builder.compileFile(input);
            this.checkModel(compiled);
        }
    }

    private void checkModel(FPGA2Model compiled) {
        String constants = compiled.getMetadata().toString();
        Assert.assertEquals((Object)"{DetectorCols=550, DetectorRows=2020, TimeP=2000 ns, BufferP=1000 ns, ISO2=200 ns, TimeS=300 ns, BufferS=100 ns, RampTime=460 ns, RampBuffer=360 ns, clockperiod=10 ns}", (Object)constants);
        String channels = compiled.getChannels().toString();
        Assert.assertEquals((Object)"{P1=8, P2=9, P3=10, P4=11, S1=4, S2=5, S3=6, RG=7, CL=3, RST=2, RD=1, RU=0, TRG=12, SOI=13, EOI=14, SHU=16}", (Object)channels);
        String subroutines = compiled.getSubroutineAddresses().toString();
        Assert.assertEquals((Object)"{FlushLine=192, WindowLine=208, BaseFrame=224, ReadFrame=240, Exposure25ms=256, ClearCCD=272, WarmUp=288, CloseShutter=304, AcquireFrame=320}", (Object)subroutines);
        String functions = compiled.getFunctionAddresses().toString();
        Assert.assertEquals((Object)"{Default=0, TransferLine=1, ReadPixel=2, StartOfImage=3, EndOfImage=4, SerialFlush=5, ExposureFlush=6, SlowFlush=7}", (Object)functions);
        String mains = compiled.getMainAddresses().toString();
        Assert.assertEquals((Object)"{Bias=0, Acquisition=4, PseudoAcquisition=8, InfiniteWait=12}", (Object)mains);
        String pointers = compiled.getPointers().toString();
        Assert.assertEquals((Object)"[PointerInfo{kind=FUNCTION, name=Exposure, address=0, value=6}, PointerInfo{kind=REPEAT_FUNCTION, name=PreCols, address=0, value=50}, PointerInfo{kind=REPEAT_FUNCTION, name=ReadCols, address=1, value=256}, PointerInfo{kind=REPEAT_FUNCTION, name=PostCols, address=2, value=244}, PointerInfo{kind=REPEAT_SUBROUTINE, name=ExposureTime, address=0, value=80}, PointerInfo{kind=REPEAT_SUBROUTINE, name=PreRows, address=1, value=100}, PointerInfo{kind=REPEAT_SUBROUTINE, name=ReadRows, address=2, value=1000}, PointerInfo{kind=REPEAT_SUBROUTINE, name=PostRows, address=3, value=920}, PointerInfo{kind=REPEAT_SUBROUTINE, name=CleaningNumber, address=4, value=2}]", (Object)pointers);
        String pointerMap = compiled.getPointerMap().toString();
        Assert.assertEquals((Object)"{Exposure=PointerInfo{kind=FUNCTION, name=Exposure, address=0, value=6}, PreCols=PointerInfo{kind=REPEAT_FUNCTION, name=PreCols, address=0, value=50}, ReadCols=PointerInfo{kind=REPEAT_FUNCTION, name=ReadCols, address=1, value=256}, PostCols=PointerInfo{kind=REPEAT_FUNCTION, name=PostCols, address=2, value=244}, ExposureTime=PointerInfo{kind=REPEAT_SUBROUTINE, name=ExposureTime, address=0, value=80}, PreRows=PointerInfo{kind=REPEAT_SUBROUTINE, name=PreRows, address=1, value=100}, ReadRows=PointerInfo{kind=REPEAT_SUBROUTINE, name=ReadRows, address=2, value=1000}, PostRows=PointerInfo{kind=REPEAT_SUBROUTINE, name=PostRows, address=3, value=920}, CleaningNumber=PointerInfo{kind=REPEAT_SUBROUTINE, name=CleaningNumber, address=4, value=2}}", (Object)pointerMap);
        CRC32 cksum = new CRC32();
        Iterator iterator = compiled.getCommands().iterator();
        while (iterator.hasNext()) {
            int[] commands;
            for (int command : commands = (int[])iterator.next()) {
                cksum.update(command);
            }
        }
        Assert.assertEquals((long)2076084475L, (long)cksum.getValue());
        cksum.reset();
        for (FPGA2Model.AddressAndValue av : compiled.getMemoryMap()) {
            cksum.update(av.getAddress());
            cksum.update(av.getValue());
        }
        Assert.assertEquals((long)748380739L, (long)cksum.getValue());
        Assert.assertEquals((long)2794727678L, (long)compiled.computeCheckSum());
    }

    @Test
    public void testComplexAssemblerCompile64() throws IOException {
        try (InputStream input = FPGA2ModelBuilderTest.class.getResourceAsStream("sequencer-reb3_64.seq");){
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            FPGA2Model compiled = builder.compileFile(input);
            this.checkModel64(compiled);
        }
    }

    @Test
    public void testComplexAssemblerCompileWithOverride() throws IOException {
        try (InputStream input = FPGA2ModelBuilderTest.class.getResourceAsStream("sequencer-reb3.seq");){
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            FPGA2Model compiled = builder.compileFile(input, new BigDecimal("6.4"));
            this.checkModel64(compiled);
        }
    }

    private void checkModel64(FPGA2Model compiled) {
        String constants = compiled.getMetadata().toString();
        Assert.assertEquals((Object)"{DetectorCols=550, DetectorRows=2020, TimeP=2000 ns, BufferP=1000 ns, ISO2=200 ns, TimeS=300 ns, BufferS=100 ns, RampTime=460 ns, RampBuffer=360 ns, clockperiod=6.4 ns}", (Object)constants);
        String channels = compiled.getChannels().toString();
        Assert.assertEquals((Object)"{P1=8, P2=9, P3=10, P4=11, S1=4, S2=5, S3=6, RG=7, CL=3, RST=2, RD=1, RU=0, TRG=12, SOI=13, EOI=14, SHU=16}", (Object)channels);
        String subroutines = compiled.getSubroutineAddresses().toString();
        Assert.assertEquals((Object)"{FlushLine=192, WindowLine=208, BaseFrame=224, ReadFrame=240, Exposure25ms=256, ClearCCD=272, WarmUp=288, CloseShutter=304, AcquireFrame=320}", (Object)subroutines);
        String functions = compiled.getFunctionAddresses().toString();
        Assert.assertEquals((Object)"{Default=0, TransferLine=1, ReadPixel=2, StartOfImage=3, EndOfImage=4, SerialFlush=5, ExposureFlush=6, SlowFlush=7}", (Object)functions);
        String mains = compiled.getMainAddresses().toString();
        Assert.assertEquals((Object)"{Bias=0, Acquisition=4, PseudoAcquisition=8, InfiniteWait=12}", (Object)mains);
        String pointers = compiled.getPointers().toString();
        Assert.assertEquals((Object)"[PointerInfo{kind=FUNCTION, name=Exposure, address=0, value=6}, PointerInfo{kind=REPEAT_FUNCTION, name=PreCols, address=0, value=50}, PointerInfo{kind=REPEAT_FUNCTION, name=ReadCols, address=1, value=256}, PointerInfo{kind=REPEAT_FUNCTION, name=PostCols, address=2, value=244}, PointerInfo{kind=REPEAT_SUBROUTINE, name=ExposureTime, address=0, value=80}, PointerInfo{kind=REPEAT_SUBROUTINE, name=PreRows, address=1, value=100}, PointerInfo{kind=REPEAT_SUBROUTINE, name=ReadRows, address=2, value=1000}, PointerInfo{kind=REPEAT_SUBROUTINE, name=PostRows, address=3, value=920}, PointerInfo{kind=REPEAT_SUBROUTINE, name=CleaningNumber, address=4, value=2}]", (Object)pointers);
        String pointerMap = compiled.getPointerMap().toString();
        Assert.assertEquals((Object)"{Exposure=PointerInfo{kind=FUNCTION, name=Exposure, address=0, value=6}, PreCols=PointerInfo{kind=REPEAT_FUNCTION, name=PreCols, address=0, value=50}, ReadCols=PointerInfo{kind=REPEAT_FUNCTION, name=ReadCols, address=1, value=256}, PostCols=PointerInfo{kind=REPEAT_FUNCTION, name=PostCols, address=2, value=244}, ExposureTime=PointerInfo{kind=REPEAT_SUBROUTINE, name=ExposureTime, address=0, value=80}, PreRows=PointerInfo{kind=REPEAT_SUBROUTINE, name=PreRows, address=1, value=100}, ReadRows=PointerInfo{kind=REPEAT_SUBROUTINE, name=ReadRows, address=2, value=1000}, PostRows=PointerInfo{kind=REPEAT_SUBROUTINE, name=PostRows, address=3, value=920}, CleaningNumber=PointerInfo{kind=REPEAT_SUBROUTINE, name=CleaningNumber, address=4, value=2}}", (Object)pointerMap);
        CRC32 cksum = new CRC32();
        Iterator iterator = compiled.getCommands().iterator();
        while (iterator.hasNext()) {
            int[] commands;
            for (int command : commands = (int[])iterator.next()) {
                cksum.update(command);
            }
        }
        Assert.assertEquals((long)2164510120L, (long)cksum.getValue());
        cksum.reset();
        for (FPGA2Model.AddressAndValue av : compiled.getMemoryMap()) {
            cksum.update(av.getAddress());
            cksum.update(av.getValue());
        }
        Assert.assertEquals((long)4085511706L, (long)cksum.getValue());
        Assert.assertEquals((long)3354918156L, (long)compiled.computeCheckSum());
    }

    @Test
    public void testMissingSlice() throws IOException {
        try (InputStream input = FPGA2ModelBuilderTest.class.getResourceAsStream("missingSlice.seq");){
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            builder.compileFile(input);
            Assert.fail();
        }
        catch (RuntimeException x) {
            Assert.assertTrue((boolean)x.getMessage().contains("at least two"));
        }
    }

    @Test
    public void testLastSliceTooShort() throws IOException {
        try (InputStream input = FPGA2ModelBuilderTest.class.getResourceAsStream("lastSliceTooShort.seq");){
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            builder.compileFile(input);
            Assert.fail();
        }
        catch (RuntimeException x) {
            Assert.assertTrue((boolean)x.getMessage().contains("Last timeslice"));
        }
    }

    @Test
    public void testFirstSliceTooShort() throws IOException {
        try (InputStream input = FPGA2ModelBuilderTest.class.getResourceAsStream("firstSliceTooShort.seq");){
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            builder.compileFile(input);
            Assert.fail();
        }
        catch (RuntimeException x) {
            Assert.assertTrue((boolean)x.getMessage().contains("First slice"));
        }
    }

    @Test
    public void testPointerInfoSerializable() throws IOException, ClassNotFoundException {
        try (InputStream input = FPGA2ModelBuilderTest.class.getResourceAsStream("sequencer-reb3.seq");){
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            FPGA2Model compiled = builder.compileFile(input);
            String pointerMap = compiled.getPointerMap().toString();
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                 ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(pointerMap);
                try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));){
                    String result = in.readObject().toString();
                    Assert.assertEquals((Object)"{Exposure=PointerInfo{kind=FUNCTION, name=Exposure, address=0, value=6}, PreCols=PointerInfo{kind=REPEAT_FUNCTION, name=PreCols, address=0, value=50}, ReadCols=PointerInfo{kind=REPEAT_FUNCTION, name=ReadCols, address=1, value=256}, PostCols=PointerInfo{kind=REPEAT_FUNCTION, name=PostCols, address=2, value=244}, ExposureTime=PointerInfo{kind=REPEAT_SUBROUTINE, name=ExposureTime, address=0, value=80}, PreRows=PointerInfo{kind=REPEAT_SUBROUTINE, name=PreRows, address=1, value=100}, ReadRows=PointerInfo{kind=REPEAT_SUBROUTINE, name=ReadRows, address=2, value=1000}, PostRows=PointerInfo{kind=REPEAT_SUBROUTINE, name=PostRows, address=3, value=920}, CleaningNumber=PointerInfo{kind=REPEAT_SUBROUTINE, name=CleaningNumber, address=4, value=2}}", (Object)result);
                }
            }
        }
    }

    @Test
    public void testModelSerializable() throws IOException, ClassNotFoundException {
        try (InputStream input = FPGA2ModelBuilderTest.class.getResourceAsStream("sequencer-reb3.seq");){
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            FPGA2Model compiled = builder.compileFile(input);
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                 ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(compiled);
                try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));){
                    FPGA2Model result = (FPGA2Model)in.readObject();
                    this.checkModel(result);
                }
            }
        }
    }
}

