package org.lsst.ccs.subsystem.rafts.states;

/**
 * RebDevice Validation State.
 * It starts in UNKNWOWN state and then it's either VALID or INVALID depending
 * on the validation of the serial number configuration parameter against the
 * serial number read from the reb boards.
 * 
 * @author The LSST CCS Team
 */
public enum RebValidationState {

    /**
     * UNKNOWN state: No validation has been performed.
     * This is the initial state.
     */
    UNKNOWN,
    
    /**
     * VALID state: the serial number configuration parameter matches the
     * serial number read from the reb board.
     * 
     */
    VALID,

    /**
     * INVALID state: the serial number configuration parameter does not match the
     * serial number read from the reb board.
     * 
     */
    INVALID;

}
