package org.lsst.ccs.subsystem.rafts.fpga.xml;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedHashSet;
import java.util.Set;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;

// TODO is the id useful ?
@XmlType
public class Timeslice implements Visitable , Serializable{

    private static final long serialVersionUID = -2695020529101043198L;

    private String requestedDuration;
    private String value;

    private int index;
    private BigDecimal startNanos;
    private BigDecimal requestedDurationNanos;
    /** The requested duration, rounded (up) to an even number of clock cycles. */
    private BigDecimal actualDurationNanos;
    private int clockCycles;
    private final Set<Channel> upChannels = new LinkedHashSet<>();
    private int clockCyclesForCompiler;

    public Timeslice() {
    }

    public Timeslice(String duration, String value) {
        super();
        this.requestedDuration = duration;
        this.value = value;
    }

    @XmlElement(name = "duration")
    public String getDuration() {
        return requestedDuration;
    }

    public void setDuration(String duration) {
        this.requestedDuration = duration;
    }

    @XmlElement(name = "value")
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    /* used during processing */
    @XmlTransient
    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @XmlTransient
    public BigDecimal getStartNanos() {
        return startNanos;
    }

    public void setStartNanos(BigDecimal startNanos) {
        this.startNanos = startNanos;
    }

    @XmlTransient
    public BigDecimal getDurationNanos() {
        return requestedDurationNanos;
    }

    public void setDurationNanos(BigDecimal durationNanos) {
        this.requestedDurationNanos = durationNanos;
    }

    @XmlTransient
    public BigDecimal getActualDurationNanos() {
        return actualDurationNanos;
    }

    public void setActualDurationNanos(BigDecimal actualDurationNanos) {
        this.actualDurationNanos = actualDurationNanos;
    }

    /**
     * This returns the actual clock cycles needed to execute the slice.
     * @return 
     */
    @XmlTransient
    public int getClockCycles() {
        return clockCycles;
    }

    public Set<Channel> getUpChannels() {
        return upChannels;
    }

    public void addUpChannel(Channel c) {
        upChannels.add(c);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public int computeClockCycles(BigDecimal clockPeriod, boolean isLast, boolean isDefault) {
        // convert nanoseconds to cycles using the current model clock period (ns)
        clockCycles = requestedDurationNanos.divide(clockPeriod).setScale(0, RoundingMode.CEILING).intValue();
        clockCyclesForCompiler = isLast ? clockCycles - 2 : index == 0 && !isDefault ? clockCycles - 1 : clockCycles;
        return clockCycles;
    }

    @XmlTransient
    public int getClockCyclesForCompiler() {
        return clockCyclesForCompiler;
    }

}
