package org.lsst.ccs.subsystem.rafts.fpga.xml;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;

import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;

//@XmlRootElement(name = "sequencer-routines")
@XmlType(propOrder = { "subroutines", "mains" })
public class SequencerRoutines implements Visitable {

	public SequencerRoutines() {
	}

	@XmlElement(name = "subroutine")
	@XmlElementWrapper(name = "subroutines")
	public List<Subroutine> getSubroutines() {
		return subroutines;
	}

	public void setSubroutines(List<Subroutine> subroutines) {
		this.subroutines = subroutines;
	}

	@XmlElement(name = "main")
	@XmlElementWrapper(name = "mains")
	public List<Main> getMains() {
		return mains;
	}

	public void setMains(List<Main> mains) {
		this.mains = mains;
	}

	List<Subroutine> subroutines = new ArrayList<Subroutine>();
	List<Main> mains = new ArrayList<Main>();

	@Override
	public void accept(Visitor v) {
		v.visit(this);
	}

	public void validate() {

	}

}
