package org.lsst.ccs.subsystem.rafts.fpga.main;

import java.math.BigDecimal;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.spi.OneArgumentOptionHandler;


public class BigDecimalOptionHandler extends OneArgumentOptionHandler<BigDecimal> {

        public BigDecimalOptionHandler(CmdLineParser parser, org.kohsuke.args4j.OptionDef option, org.kohsuke.args4j.spi.Setter<? super BigDecimal> setter) {
            super(parser, option, setter);
        }

        @Override
        protected BigDecimal parse(String argument) throws org.kohsuke.args4j.CmdLineException {
            try {
                return new BigDecimal(argument);
            } catch (NumberFormatException e) {
                throw new org.kohsuke.args4j.CmdLineException(owner, "Invalid BigDecimal value: " + argument, e);
            }
        }
    }