package org.lsst.ccs.subsystem.rafts.data;

import java.io.Serializable;
import org.lsst.ccs.drivers.reb.Status;

/**
 ****************************************
 *
 *  Contains a set of REB status data
 *
 *  @author Owen Saxton
 *
 ****************************************
 */
public class StatusData implements Serializable {

    private final int version;
    private final int linkStat;
    private final int cerrCount;
    private final int ldwnCount;
    private final int lerrCount;
    private final int buffStat;
    private final int[] rxCount = new int[4];
    private final int[] txCount = new int[4];
    private final int sentCount;
    private final int discCount;
    private final int truncCount;
    private final int format;

    public StatusData(Status stat) {
        version = stat.getVersion();
        linkStat = stat.getLinkStatus();
        cerrCount = stat.getCellErrorCount();
        ldwnCount = stat.getLinkDownCount();
        lerrCount = stat.getLinkErrorCount();
        buffStat = stat.getVcBufferStatus();
        System.arraycopy(stat.getVcRxCounts(), 0, rxCount, 0, rxCount.length);
        System.arraycopy(stat.getVcTxCounts(), 0, txCount, 0, txCount.length);
        sentCount = stat.getSentCount();
        discCount = stat.getDiscCount();
        truncCount = stat.getTruncCount();
        format = stat.getFormat();
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("Status Block:\n");
        str.append(String.format("  Version            = %08x  ", version));
        str.append(String.format("  Link Status        = %08x\n", linkStat));
        str.append(String.format("  Cell error count   = %-8s  ", cerrCount));
        str.append(String.format("  Link down count    = %s\n", ldwnCount));
        str.append(String.format("  Link error count   = %-8s  ", lerrCount));
        str.append(String.format("  VC buffer status   = %08x\n", buffStat));
        str.append(String.format("  VC rcve counts     ="));
        for (int j = 0; j < rxCount.length; j++)
            str.append(String.format(" %s", rxCount[j]));
        str.append("\n");
        str.append(String.format("  VC xmit counts     ="));
        for (int j = 0; j < txCount.length; j++)
            str.append(String.format(" %s", txCount[j]));
        str.append("\n");
        str.append(String.format("  Sent image count   = %-8s  ", sentCount));
        str.append(String.format("  Disc. image count  = %s\n", discCount));
        str.append(String.format("  Trunc. image count = %-8s  ", truncCount));
        str.append(String.format("  Image format       = %s", format));

        return str.toString();
    }

    private static final long serialVersionUID = 1862820319013212211L;
}
