package org.lsst.ccs.subsystem.rafts.data;

import java.io.Serializable;

/**
 *******************************************************
 *
 *  Contains the meta-information for an image.
 *
 *  Sent on the status bus whenever an image is read
 *
 *  @author Owen Saxton
 *
 *******************************************************
 */
public class ImageState implements Serializable {

    public static final String KEY = "ImageState";
    private final long timestamp;
    private final int length;

    public ImageState(long timestamp, int length) {
        super();
        this.timestamp = timestamp;
        this.length = length;
    }
    
    public long getTimestamp() {
        return timestamp;
    }

    public int getLength() {
        return length;
    }

    @Deprecated
    public long getTag() {
        return timestamp;
    }

    private static final long serialVersionUID = 5519335036986674246L;
}
