/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lambda;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.i2c.I2c;
import org.lsst.ccs.drivers.lambda.Cpfe1000;

public class TestCpfe1000 {
    private static final Map<Integer, String> modelMap = new HashMap<Integer, String>();
    private static final int MAX_DEVICE = 4;
    private final Cpfe1000[] cpfe = new Cpfe1000[4];
    private int nOpen = 0;

    public TestCpfe1000() {
        for (int j = 0; j < this.cpfe.length; ++j) {
            this.cpfe[j] = new Cpfe1000();
        }
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="type", description="Connection type") I2c.ConnType connType, @Argument(name="ident", description="Identification") String ident, int ... addrs) throws DriverException {
        if (this.nOpen > 0) {
            throw new DriverException("Device(s) already open");
        }
        if (addrs.length == 0) {
            throw new DriverException("No devices specified");
        }
        if (addrs.length >= 4) {
            throw new DriverException("Too many devices specified");
        }
        for (int j = 0; j < addrs.length; ++j) {
            try {
                this.cpfe[j].open(connType, ident, addrs[j]);
                continue;
            }
            catch (DriverException e) {
                for (int k = 0; k < j; ++k) {
                    this.cpfe[k].close();
                }
                throw e;
            }
        }
        this.nOpen = addrs.length;
    }

    @Command(name="close", description="Close the connection")
    public void close() throws DriverException {
        this.checkOpen();
        for (int j = 0; j < this.nOpen; ++j) {
            try {
                this.cpfe[j].close();
                continue;
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
        this.nOpen = 0;
    }

    @Command(name="showmodel", description="Show the model name")
    public String showModel(int ... devs) throws DriverException {
        this.checkOpen();
        StringBuilder text = new StringBuilder();
        for (int j : this.getIndices(devs)) {
            text.append(modelMap.get(this.cpfe[j].getModel())).append(" ");
        }
        return text.toString();
    }

    @Command(name="showserial", description="Show the serial number")
    public String showSerial(int ... devs) throws DriverException {
        this.checkOpen();
        StringBuilder text = new StringBuilder();
        for (int j : this.getIndices(devs)) {
            text.append(this.cpfe[j].getSerialNo()).append(" ");
        }
        return text.toString();
    }

    @Command(name="showfirmware", description="Show the firmware revision")
    public String showFirmware(int ... devs) throws DriverException {
        this.checkOpen();
        StringBuilder text = new StringBuilder();
        for (int j : this.getIndices(devs)) {
            text.append(this.cpfe[j].getFirmwareRev()).append(" ");
        }
        return text.toString();
    }

    @Command(name="showproduct", description="Show the product revision")
    public String showProduct(int ... devs) throws DriverException {
        this.checkOpen();
        StringBuilder text = new StringBuilder();
        for (int j : this.getIndices(devs)) {
            text.append(this.cpfe[j].getProductRev()).append(" ");
        }
        return text.toString();
    }

    @Command(name="showunitpart", description="Show the unit part number")
    public String showUnitPart(int ... devs) throws DriverException {
        this.checkOpen();
        StringBuilder text = new StringBuilder();
        for (int j : this.getIndices(devs)) {
            text.append(this.cpfe[j].getUnitPartNo()).append(" ");
        }
        return text.toString();
    }

    @Command(name="showdatemanu", description="Show the manufacture date")
    public String showDateManu(int ... devs) throws DriverException {
        this.checkOpen();
        StringBuilder text = new StringBuilder();
        for (int j : this.getIndices(devs)) {
            text.append(this.cpfe[j].getManufactureDate()).append(" ");
        }
        return text.toString();
    }

    @Command(name="showlocmanu", description="Show the manufacture location")
    public String showLocManu(int ... devs) throws DriverException {
        this.checkOpen();
        StringBuilder text = new StringBuilder();
        for (int j : this.getIndices(devs)) {
            text.append(this.cpfe[j].getManufactureLoc()).append(" ");
        }
        return text.toString();
    }

    @Command(name="showstatus", description="Show the status byte")
    public String showStatus(int ... devs) throws DriverException {
        this.checkOpen();
        StringBuilder text = new StringBuilder();
        for (int j : this.getIndices(devs)) {
            text.append(String.format("%02x", this.cpfe[j].readStatus())).append(" ");
        }
        return text.toString();
    }

    @Command(name="showvoltage", description="Show the voltage")
    public String showVoltage(int ... devs) throws DriverException {
        this.checkOpen();
        StringBuilder text = new StringBuilder();
        for (int j : this.getIndices(devs)) {
            text.append(String.format("%.2f", this.cpfe[j].readVoltage())).append(" ");
        }
        return text.toString();
    }

    @Command(name="showcurrent", description="Show the current")
    public String showCurrent(int ... devs) throws DriverException {
        this.checkOpen();
        StringBuilder text = new StringBuilder();
        for (int j : this.getIndices(devs)) {
            text.append(String.format("%.2f", this.cpfe[j].readCurrent())).append(" ");
        }
        return text.toString();
    }

    @Command(name="showtemperature", description="Show the temperature")
    public String showTemperature(int ... devs) throws DriverException {
        this.checkOpen();
        StringBuilder text = new StringBuilder();
        for (int j : this.getIndices(devs)) {
            text.append(String.format("%.2f", this.cpfe[j].readTemperature())).append(" ");
        }
        return text.toString();
    }

    @Command(name="power", description="Turn the power on or off")
    public void power(@Argument(name="action", description="Action: on or off") OnOff action, int ... devs) throws DriverException {
        this.checkOpen();
        for (int j : this.getIndices(devs)) {
            if (action == OnOff.ON) {
                this.cpfe[j].powerOn();
                continue;
            }
            this.cpfe[j].powerOff();
        }
    }

    private void checkOpen() throws DriverException {
        if (this.nOpen == 0) {
            throw new DriverException("No devices open");
        }
    }

    private int[] getIndices(int[] devs) throws DriverException {
        if (devs.length == 0) {
            int[] indices = new int[this.nOpen];
            for (int j = 0; j < indices.length; ++j) {
                indices[j] = j;
            }
            return indices;
        }
        for (int dev : devs) {
            if (dev >= 0 && dev < this.nOpen) continue;
            throw new DriverException("Invalid device index: " + dev);
        }
        return devs;
    }

    static {
        modelMap.put(0, "12");
        modelMap.put(1, "28");
        modelMap.put(2, "48");
        modelMap.put(3, "I12");
        modelMap.put(4, "I28");
        modelMap.put(5, "I48");
        modelMap.put(-1, "Unknown");
    }

    protected static enum OnOff {
        ON,
        OFF;

    }
}

