/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.auxelex.PduCommon;
import org.lsst.ccs.drivers.auxelex.PduHV;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.power.PduCommonDevice;

public class PduHvDevice
extends PduCommonDevice {
    private static final int MON_TYPE_MAIN_VOLTAGE = 2;
    private static final int MON_TYPE_MAIN_CURRENT = 3;
    private static final int MON_TYPE_MAIN_TEMP = 4;
    private static final int MON_TYPE_BOARD_TEMP = 5;
    private static final int MON_TYPE_FPGA_TEMP = 6;
    private static final Map<String, Integer> mTypeMap = new HashMap<String, Integer>();
    private final PduHV pduHV;

    public PduHvDevice(PduHV pdu, String pduType, int swDevc) {
        super((PduCommon)pdu, pduType, swDevc);
        this.pduHV = pdu;
    }

    @Override
    protected int[] checkChannel(Channel ch) throws Exception {
        String type = ch.getTypeStr();
        Integer mType = mTypeMap.get(type.toUpperCase());
        if (mType == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"type", (Object)type);
        }
        return new int[]{mType, 0};
    }

    @Override
    protected double readChannel(Channel ch) {
        double value = Double.NaN;
        String item = null;
        if (this.isOnline()) {
            int type = ch.getType();
            int hwChan = ch.getHwChan();
            try {
                switch (type) {
                    case 0: {
                        item = "voltage";
                        value = this.pduHV.readVoltage(hwChan);
                        break;
                    }
                    case 1: {
                        item = "current";
                        value = this.pduHV.readCurrent(hwChan);
                        break;
                    }
                    case 2: {
                        item = "main voltage";
                        value = this.pduHV.readMainVoltage();
                        break;
                    }
                    case 3: {
                        item = "main current";
                        value = this.pduHV.readMainCurrent();
                        break;
                    }
                    case 4: {
                        item = "main temperature";
                        value = this.pduHV.readMainTemperature();
                        break;
                    }
                    case 5: {
                        item = "board temperature";
                        value = this.pduHV.readBoardTemperature();
                        break;
                    }
                    case 6: {
                        item = "FPGA temperature";
                        value = this.pduHV.readFpgaTemperature();
                    }
                }
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading {0} {1}: {2}", new Object[]{this.fullName, item, e});
                this.setOnline(false);
            }
        }
        return value;
    }

    static {
        mTypeMap.put("VOLTAGE", 0);
        mTypeMap.put("CURRENT", 1);
        mTypeMap.put("MAINVOLT", 2);
        mTypeMap.put("MAINCURR", 3);
        mTypeMap.put("MAINTEMP", 4);
        mTypeMap.put("BOARDTEMP", 5);
        mTypeMap.put("FPGATEMP", 6);
    }
}

