/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import com.sun.management.OperatingSystemMXBean;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import org.lsst.ccs.bus.annotations.DataAttributes;

public final class RuntimeInfo
implements Serializable {
    private static final long serialVersionUID = -72154637904826248L;
    private static final long MEGABYTE = 1000000L;
    @DataAttributes(description="Number of Threads allocated by the CCS process", units="unitless")
    private final int nThreads;
    @DataAttributes(description="Maximum Memory available to the JVM", units="MB")
    private final long maxMemory = Runtime.getRuntime().maxMemory() / 1000000L;
    @DataAttributes(description="Total Memory allocated by JVM", units="MB")
    private final long totalMemory;
    @DataAttributes(description="Unused Memory allocated by the JVM", units="MB")
    private final long freeMemory;
    @DataAttributes(description="Memory used by the JVM", units="MB")
    private final long usedMemory;
    @DataAttributes(description="Available Memory that could be used by the JVM", units="MB")
    private final long availableMemory;
    @DataAttributes(description="Recent cpu usage for the whole system. This value is a double in the [0.0,1.0] interval.", units="unitless")
    private final double processCpuLoad;
    @DataAttributes(description="Recent cpu usage for the JVM process. This value is a double in the [0.0,1.0] interval.", units="unitless")
    private final double systemCpuLoad;
    private static final transient OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    private static final transient Runtime runtime = Runtime.getRuntime();
    @DataAttributes(description="Number of seconds since the CCS process was started", units="s")
    private final long uptime;

    public RuntimeInfo() {
        this(0L);
    }

    public RuntimeInfo(long uptime) {
        this.nThreads = ManagementFactory.getThreadMXBean().getThreadCount();
        this.freeMemory = runtime.freeMemory() / 1000000L;
        this.totalMemory = runtime.totalMemory() / 1000000L;
        this.usedMemory = this.totalMemory - this.freeMemory;
        this.availableMemory = this.maxMemory - this.usedMemory;
        this.processCpuLoad = osBean.getProcessCpuLoad();
        this.systemCpuLoad = osBean.getCpuLoad();
        this.uptime = uptime;
    }

    public int getNThreads() {
        return this.nThreads;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public long getAvailableMemory() {
        return this.availableMemory;
    }

    public double getProcessCpuLoad() {
        return this.processCpuLoad;
    }

    public double getSystemCpuLoad() {
        return this.systemCpuLoad;
    }

    public long getUptime() {
        return this.uptime;
    }
}

