/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.keithley;

import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;

public class N6517
extends Scpi {
    public static double timeout = 60.0;
    public static final int DEFAULT_BAUD = 19200;
    public static final String DEFAULT_DEV = "/dev/ttyUSB0";
    private static final double MINBIAS = -75.0;
    private static final double MAXBIAS = 5.0;

    public void open(String devname) throws DriverException {
        this.open(devname, 19200);
        this.reset();
    }

    public void open() throws DriverException {
        this.open(DEFAULT_DEV, 19200);
        this.setTimeout(timeout);
        this.reset();
    }

    public void open(String devname, int port) throws DriverException {
        this.open(DriverConstants.ConnType.SERIAL, devname, port);
        this.checkIdentification("KEITHLEY", 1, "MODEL 648", 1);
        this.setTimeout(timeout);
        this.reset();
    }

    public String printdevid() throws DriverException {
        String[] id = this.getIdentification();
        return "Successfully connected to:\nManufacturer:   " + id[0] + "\nModel name:     " + id[1] + "\nSerial number:  " + id[2] + "\nF/W version:    " + id[3];
    }

    @Override
    public void reset() throws DriverException {
        this.writeKthly("*RST");
        this.writeKthly("ARM:COUN 1");
        this.writeKthly("TRAC:FEED:CONT NEVER");
        this.writeKthly("SOUR:VOLT:SWE:ABOR");
    }

    public void setOutput(boolean on) throws DriverException {
        this.writeKthly("SOUR:VOLT:STAT " + (on ? "ON" : "OFF"));
    }

    public boolean getOutput() throws DriverException {
        return this.readIntegerKthly("SOUR:VOLT:STAT?") != 0;
    }

    public void setRate(int value) throws DriverException {
        this.writeKthly("CURR:NPLC " + value);
    }

    public void setArmCount(int value) throws DriverException {
        this.writeKthly("ARM:COUN " + value);
    }

    public void setTrigCount(int value) throws DriverException {
        this.writeKthly("TRIG:COUN " + value);
    }

    public void setBuffSize(int value) throws DriverException {
        this.writeKthly("TRAC:POIN " + value);
    }

    public void clrBuff() throws DriverException {
        this.writeKthly("TRAC:CLE");
    }

    public void setVoltageRange(double value) throws DriverException {
        this.writeKthly("SOUR:VOLT:RANG " + value);
    }

    public void setVoltage(double value) throws DriverException {
        double usedvalue = 0.0;
        if (value < -75.0 || value > 5.0) {
            System.out.println("Only values between -75.V and 5.V are allowed in order to protect the CCD!");
            throw new DriverException();
        }
        usedvalue = value;
        this.writeKthly("SOUR:VOLT " + usedvalue);
    }

    public void rampVolts_sweep(double duration, double value, int nsteps) throws DriverException {
        double vnow = this.readVoltage();
        double vstep = Math.abs(value - vnow) / (double)nsteps;
        double delta = duration / (double)nsteps;
        System.out.println("starting ramp from " + Double.toString(vnow) + " to " + Double.toString(value) + " with vstep = " + Double.toString(vstep) + " with tstep = " + Double.toString(delta));
        this.writeKthly("SOUR:VOLT " + value);
        this.writeKthly("SOUR:VOLT:SWE:STAR " + vnow);
        this.writeKthly("SOUR:VOLT:SWE:STOP " + value);
        this.writeKthly("SOUR:VOLT:SWE:STEP " + vstep);
        this.writeKthly("SOUR:VOLT:SWE:DEL " + delta);
        this.setArmCount(nsteps + 1);
        this.writeKthly("FORM:ELEM READ");
        this.writeKthly("SOUR:VOLT:SWE:INIT");
        this.writeKthly("SYST:ZCH OFF");
        System.out.println("started ramp");
        double[] buff = this.readDoubleArray("READ?");
        System.out.println("ramp completed");
    }

    public void rampVolts(double duration, double value, int nsteps) throws DriverException {
        double vnow = this.readVoltage();
        double vstep = (value - vnow) / (double)nsteps;
        int delta = (int)(1000.0 * duration / (double)nsteps);
        System.out.println("ramp from " + Double.toString(vnow) + " to " + Double.toString(value) + " with vstep = " + Double.toString(vstep) + " with tstep = " + Integer.toString(delta));
        System.out.println("starting ramp");
        double v = vnow;
        for (int istep = 0; istep < nsteps + 1; ++istep) {
            System.out.println("V = " + v);
            this.setVoltage(v);
            try {
                Thread.currentThread();
                Thread.sleep(delta);
            }
            catch (Exception exception) {
                // empty catch block
            }
            v += vstep;
        }
        System.out.println("ramp completed");
    }

    public void rampVolts(double duration, double value) throws DriverException {
        int nsteps = 10;
        this.rampVolts(duration, value, nsteps);
    }

    public double getVoltage() throws DriverException {
        return this.readDoubleKthly("SOUR:VOLT?");
    }

    public void zeroCorrectVoltage() throws DriverException {
        this.writeKthly("SYST:ZCH ON");
        this.writeKthly("SYST:GUAR ON");
        this.writeKthly("FUNC 'VOLT'");
        this.writeKthly("SYST:ZCOR ON");
        this.writeKthly("SYST:ZCH OFF");
    }

    public double readVoltage() throws DriverException {
        this.setArmCount(1);
        this.writeKthly("SYST:ZCH OFF");
        this.writeKthly("FORM:ELEM VSO");
        return this.readDoubleKthly("READ?");
    }

    public void setCurrentRange(double value) throws DriverException {
        this.writeKthly("FUNC 'CURR'");
        this.writeKthly("RANG " + value);
    }

    public void setCurrent(double value) throws DriverException {
        this.writeKthly("SOUR:CURR " + value);
    }

    public double getCurrent() throws DriverException {
        return this.readDoubleKthly("CURR?");
    }

    public void zeroCorrectCurrent() throws DriverException {
        this.writeKthly("SYST:ZCH ON");
        this.writeKthly("FUNC 'CURR'");
        this.writeKthly("INIT");
        this.writeKthly("SYST:ZCOR:ACQ");
        this.writeKthly("SYST:ZCOR ON");
        this.writeKthly("SYST:ZCH OFF");
    }

    public double readCurrent() throws DriverException {
        this.setArmCount(1);
        this.writeKthly("SYST:ZCH OFF");
        this.writeKthly("FORM:ELEM READ");
        return this.readDoubleKthly("READ?");
    }

    public void setVoltageLimit(double maxima) throws DriverException {
        this.writeKthly("SOUR:VOLT:LIM " + maxima);
    }

    public double getVoltageLimit() throws DriverException {
        return this.readDoubleKthly("SOUR:VOLT:LIM?");
    }

    public void setCurrentLimit(double maxima) throws DriverException {
        this.writeKthly("SOUR:VOLT:ILIM " + maxima);
    }

    public double getCurrentLimit() throws DriverException {
        return this.readDoubleKthly("SOUR:VOLT:ILIM?");
    }

    public double[] readBuffer() throws DriverException {
        this.writeKthly("TRAC:FEED:CONT NEVER");
        this.writeKthly("FORM:ELEM READ");
        this.writeKthly("TRAC:FEED SENS");
        this.writeKthly("TRAC:FEED:CONT NEXT");
        this.writeKthly("SYST:ZCH OFF");
        this.writeKthly("INIT");
        double[] buff = this.readDoubleArray("TRAC:DATA?");
        this.writeKthly("TRAC:FEED:CONT NEVER");
        return buff;
    }

    private void writeKthly(String instr) throws DriverException {
        this.writeCommand(instr);
    }

    private String readStringKthly(String instr) throws DriverException {
        return this.readString(instr);
    }

    private double readDoubleKthly(String instr) throws DriverException {
        return this.readDouble(instr);
    }

    private int readIntegerKthly(String instr) throws DriverException {
        return this.readInteger(instr);
    }
}

