/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.util.List;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.states.AlertState;

public interface Dispatcher {
    public void initialize();

    public void shutdown();

    public Task in(BusMessage var1, long var2, Runnable var4, Bus var5, String ... var6);

    public Task out(BusMessage var1, long var2, Runnable var4, Bus var5, Order var6);

    public void addListener(Listener var1);

    public void removeListener(Listener var1);

    public void fireEvent(Event var1);

    public void addTaskListener(TaskListener var1);

    public void removeTaskListener(TaskListener var1);

    public void removeAllTaskListeners();

    public void raiseAlert(String var1, AlertState var2, String var3);

    public void raiseAlert(Alert var1, AlertState var2, String var3);

    public List<Alert> getRegisteredAlerts();

    public void registerAlert(Alert var1);

    public Logger getLogger();

    public static interface Task {
        public BusMessage getBusMessage();

        public Bus getBus();

        public boolean isOutgoing();

        public long getRefTime();

        public int getDuration(Stage var1);

        public int getDuration();

        public Runnable getPayload();
    }

    public static class AlertEvent
    extends Event {
        private final Alert alert;
        private final AlertState severity;
        private final String cause;

        public AlertEvent(Dispatcher dispatcher, Alert alert, AlertState severity, String cause) {
            super(dispatcher);
            this.alert = alert;
            this.severity = severity;
            this.cause = cause;
        }

        public Alert getAlert() {
            return this.alert;
        }

        public AlertState getSeverity() {
            return this.severity;
        }

        public String getCause() {
            return this.cause;
        }
    }

    public static interface TaskListener {
        public void stageEnded(Task var1, Stage var2);
    }

    public static interface Listener {
        public void onEvent(Event var1);
    }

    public static class Event {
        protected final Dispatcher dispatcher;

        protected Event(Dispatcher dispatcher) {
            this.dispatcher = dispatcher;
        }

        public Dispatcher getDispatcher() {
            return this.dispatcher;
        }
    }

    public static enum Stage {
        START,
        WAIT,
        RUN,
        SUBMIT;

    }

    public static enum Order {
        NORM,
        OOB_CC,
        OOB;

    }
}

