/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.power.SwitchControl;
import org.lsst.ccs.subsystem.power.constants.PathFinderQuadBoxSwitches;
import org.lsst.ccs.subsystem.power.constants.SwitchState;
import org.lsst.ccs.subsystem.power.data.PathFinderQuadBoxState;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.utilities.logging.Logger;

public class PathFinderQuadBox
extends Subsystem
implements HasLifecycle {
    private static final Map<Integer, String> typeMap = new HashMap<Integer, String>();
    private static final Logger LOG;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService aps;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService apts;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<SwitchControl> swDeviceList = new ArrayList<SwitchControl>();
    private final SwitchControl[] swDevices = new SwitchControl[6];
    private final PathFinderQuadBoxState qbState = new PathFinderQuadBoxState();

    public PathFinderQuadBox() {
        super("pathfinderquadbox", AgentInfo.AgentType.WORKER);
    }

    public void postInit() {
        this.aps.setAgentProperty("pathfinderQuadBoxAgent", ((Object)((Object)this)).getClass().getCanonicalName());
        boolean error = false;
        for (SwitchControl sd : this.swDeviceList) {
            LOG.error((Object)("sd = " + sd));
            this.swDevices[sd.getSwitchDevice()] = sd;
        }
        for (int j = 0; j < this.swDevices.length; ++j) {
            if (this.swDevices[j] != null) continue;
            LOG.error((Object)("The " + typeMap.get(j) + " device has not been specified"));
            error = true;
        }
        if (error) {
            throw new RuntimeException("Fatal initialization error");
        }
    }

    public void postStart() {
        this.updateState();
        this.publishState();
        LOG.info((Object)"PathFinder Quad Box subsystem started");
    }

    public void periodicBroadcast() {
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a switch")
    public void setSwitchOn(@Argument(description="The switch number") int sw, @Argument(description="Whether to turn on") boolean on) throws PowerException {
        int devNum = sw >> 8;
        byte swNum = (byte)sw;
        if (devNum < 0 || devNum >= 6 || swNum >= PathFinderQuadBoxSwitches.NUM_SWITCHES[devNum]) {
            throw new PowerException("Invalid switch number: " + sw);
        }
        if (on) {
            this.swDevices[devNum].switchOn(swNum);
        } else {
            this.swDevices[devNum].switchOff(swNum);
        }
        this.updateState();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a named switch")
    public void setNamedSwitchOn(@Argument(description="The switch name") String name, @Argument(description="Whether to turn on") boolean on) throws PowerException {
        Integer sw = (Integer)PathFinderQuadBoxSwitches.switchNameToId.get(name);
        if (sw == null) {
            throw new PowerException("Invalid switch name: " + name);
        }
        this.setSwitchOn(sw, on);
    }

    @Command(type=Command.CommandType.QUERY, description="Get list of switch names")
    public List<String> getSwitchNames() {
        return new ArrayList<String>(PathFinderQuadBoxSwitches.switchNameToId.keySet());
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update period")
    public void setUpdatePeriod(@Argument(name="period", description="The tick period (msecs)") int period) {
        this.setTickPeriod(period);
        this.publishState();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full state")
    public PathFinderQuadBoxState getFullState() throws PowerException {
        this.updateState();
        this.qbState.setTickMillis(this.getTickPeriod());
        return this.qbState;
    }

    private void updateState() {
        for (int devNum = 0; devNum < 6; ++devNum) {
            if (devNum == 5) continue;
            for (int swNum = -1; swNum < PathFinderQuadBoxSwitches.NUM_SWITCHES[devNum]; ++swNum) {
                LOG.error((Object)("sd = " + this.swDevices[devNum] + " , swnum = " + swNum));
                Boolean st = this.swDevices[devNum].isSwitchOn(swNum);
                SwitchState ss = st == null ? SwitchState.OFFLINE : (st != false ? SwitchState.ON : SwitchState.OFF);
                this.qbState.setSwitchState(devNum, swNum, ss);
            }
        }
    }

    private void setTickPeriod(long period) {
        this.apts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.apts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    private void publishState() {
        this.qbState.setTickMillis(this.getTickPeriod());
        KeyValueData kvd = new KeyValueData("PathFinderQuadBoxState", (Serializable)this.qbState);
        this.publishSubsystemDataOnStatusBus(kvd);
    }

    static {
        typeMap.put(0, "BFR");
        typeMap.put(1, "5V PDU");
        typeMap.put(2, "24V clean PDU");
        typeMap.put(3, "24V dirty PDU");
        typeMap.put(4, "48V PDU");
        LOG = Logger.getLogger((String)PathFinderQuadBox.class.getName());
    }

    static class DummyDevice
    implements SwitchControl {
        DummyDevice() {
        }

        @Override
        public int getSwitchDevice() {
            return 0;
        }

        @Override
        public Boolean isSwitchOn(int sw) {
            return null;
        }

        @Override
        public void switchOn(int sw) {
        }

        @Override
        public void switchOff(int sw) {
        }
    }
}

