/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.utilities.conv.InputConversionEngine;

public class PowerSupplyConfiguration {
    private static final Logger LOG = Logger.getLogger(PowerSupplyConfiguration.class.getName());
    private final String name;
    private final List<String> rebs;
    private final boolean isCornerRaft;

    PowerSupplyConfiguration(String name, Properties props) {
        this.name = name;
        this.isCornerRaft = Boolean.valueOf(props.getProperty("org.lsst.ccs.power." + name + ".isCornerRaft", "false"));
        String rebsBuildProperty = "org.lsst.ccs.power." + name + ".rebs";
        this.rebs = (List)InputConversionEngine.convertArgToType((String)props.getProperty(rebsBuildProperty), List.class);
        if (this.rebs.isEmpty()) {
            LOG.log(Level.WARNING, "No REBs have been provided for Power Supply {0} in build configuration {1}", new Object[]{name, rebsBuildProperty});
        }
    }

    public boolean isCornerRaft() {
        return this.isCornerRaft;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getRebs() {
        return this.rebs;
    }
}

