package org.lsst.ccs.subsystem.power;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.AlertRaisingAlarm;
import org.lsst.ccs.subsystem.common.actions.RebPowerAction;
import org.lsst.ccs.subsystem.power.alerts.RebPowerAlertType;

/**
 * An Alarm class for a given Reb.
 *
 * @author The LSST CCS Team
 */
public class RebPowerAlarm extends AlertRaisingAlarm {

    @LookupField(strategy = LookupField.Strategy.ANCESTORS)
    RebPowerSupplyNode rebNode;

    RebPowerAlertType alertType = null;
    
    
    @Override
    public void build() {
        if ( rebNode == null ) {
            throw new RuntimeException("A RebPowerAlarm must defined within a RebPowerSupplyNode.");
        }
        if ( alertType == null ) {
            throw new RuntimeException("An alert type must be specified.");
        }
        super.build();
        this.description = alertType.getDescription();
    }
    
    RebPowerSupplyNode getRebNode() {
        return rebNode;
    }
    
    @Override
    public Alert getAlert(AlertState state, AlertState previousAlertState) {
        Alert alert = getRebPowerAlert(alertType,rebNode.rebPath);
        //Add a RebPowerAction payload only if in ALARM state and if the current or the voltages are too high
        if ( alertType == RebPowerAlertType.HVBIAS_CURRENT_TOO_HIGH || alertType == RebPowerAlertType.HVBIAS_VOLTAGE_TOO_HIGH ) {
            if (state == AlertState.ALARM) {
                RebPowerAction.addRebPowerActionPayloadToAlert(alert, RebPowerAction.Type.TURN_REB_HVBIAS_OFF, rebNode.rebPath);
            }
        }
        return alert;                
    }

    /**
     * Utility method to create an Alert of a given type and for the given Reb
     * @param type    The RebPowerAlertType of this Alert
     * @param rebPath The path of the Reb
     * @return        The corresponding Alert
     */
    public static Alert getRebPowerAlert(RebPowerAlertType type, String rebPath) {
        return new Alert(type.getAlertId()+"/"+rebPath,type.getDescription());        
    }
    
}
