/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ametek;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class AvcCooler
extends Ascii {
    private static final Map<String, Mode> modeMap = new HashMap<String, Mode>();
    private static final int DEFAULT_BAUDRATE = 9600;

    public AvcCooler() {
        this.setOptions(Ascii.Option.NO_NET);
        this.setDefaultParm(9600);
    }

    public void open(DriverConstants.ConnType connType, String ident, int baudRate, int dataChar) throws DriverException {
        super.open(connType, ident, baudRate, dataChar);
        this.setCommandTerm(Ascii.Terminator.CR);
        this.setResponseTerm(Ascii.Terminator.CRLF);
    }

    public String getProductType() throws DriverException {
        return this.readString("MODE");
    }

    public String getFWVersion() throws DriverException {
        return this.readString("VERSION");
    }

    public String getSensor() throws DriverException {
        return this.readString("SENSOR");
    }

    public void lock(String passwd) throws DriverException {
        this.readDouble("LOGOUT=" + passwd);
    }

    public void unlock(String passwd) throws DriverException {
        this.readDouble("LOGIN=" + passwd);
    }

    public boolean isLocked() throws DriverException {
        return this.readDouble("LOGIN") == 1.0;
    }

    public void setPassword(String passwd) throws DriverException {
        this.readDouble("PASSWD=" + passwd);
    }

    public void setMode(Mode mode) throws DriverException {
        String resp = this.readString("COOLER=" + (Object)((Object)mode));
        Mode retMode = modeMap.get(resp);
        if (retMode == null || retMode != mode) {
            AvcCooler.unexpectedResponse(resp);
        }
    }

    public Mode getMode() throws DriverException {
        String resp = this.readString("COOLER");
        Mode mode = modeMap.get(resp);
        if (mode == null) {
            AvcCooler.unexpectedResponse(resp);
        }
        return mode;
    }

    public void setTemperature(double temp) throws DriverException {
        this.readDouble("TTARGET=" + temp);
    }

    public double getTemperature() throws DriverException {
        return this.readDouble("TTARGET");
    }

    public void setPower(double power) throws DriverException {
        this.readDouble("PWOUT=" + power);
    }

    public double getPower() throws DriverException {
        return this.readDouble("PWOUT");
    }

    public double[] getAllPower() throws DriverException {
        String[] resp = this.readLines("E", 3);
        double[] values = new double[3];
        for (int j = 0; j < values.length; ++j) {
            try {
                values[j] = Double.valueOf(resp[j]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new DriverException("Invalid numeric value: " + resp[j]);
            }
        }
        return values;
    }

    public double readTemperature() throws DriverException {
        return this.readDouble("TC");
    }

    public double readRejectTemp() throws DriverException {
        return this.readDouble("TEMP RJ");
    }

    public double readPower() throws DriverException {
        return this.readDouble("P");
    }

    public int getError() throws DriverException {
        String resp = this.readString("ERROR");
        if (!resp.matches("[01][01][01][01][01][01][01][01]")) {
            AvcCooler.unexpectedResponse(resp);
        }
        int value = 0;
        for (int j = 0; j < 8; ++j) {
            if (resp.charAt(j) != '1') continue;
            value |= 1 << 7 - j;
        }
        return value;
    }

    public void setProportional(double value) throws DriverException {
        this.readDouble("KP=" + value);
    }

    public double getProportional() throws DriverException {
        return this.readDouble("KP");
    }

    public void setIntegral(double value) throws DriverException {
        this.readDouble("KI=" + value);
    }

    public double getIntegral() throws DriverException {
        return this.readDouble("KI");
    }

    public void setDerivative(double value) throws DriverException {
        this.readDouble("KD=" + value);
    }

    public double getDerivative() throws DriverException {
        return this.readDouble("KD");
    }

    public String[] readLines(String command, int nLines) throws DriverException {
        this.flush();
        String echo = this.read(command);
        if (!echo.equals(command)) {
            throw new DriverException("Unexpected command echo: " + echo);
        }
        String resp = this.read();
        if (resp.toLowerCase().startsWith("undefined")) {
            throw new DriverException("Undefined command");
        }
        if (resp.toLowerCase().contains("locked")) {
            throw new DriverException("Command is user locked");
        }
        String[] lines = new String[nLines];
        lines[0] = resp;
        for (int j = 1; j < nLines; ++j) {
            lines[j] = this.read();
        }
        return lines;
    }

    public String readString(String command) throws DriverException {
        String[] lines = this.readLines(command, 1);
        return lines[0];
    }

    public double readDouble(String command) throws DriverException {
        String resp = this.readString(command);
        try {
            return Double.valueOf(resp);
        }
        catch (NumberFormatException e) {
            throw new DriverException("Invalid numeric value: " + resp);
        }
    }

    private static void unexpectedResponse(String resp) throws DriverException {
        throw new DriverException("Unexpected response: " + resp);
    }

    static {
        for (Mode mode : Mode.values()) {
            modeMap.put(mode.name(), mode);
        }
    }

    public static enum Mode {
        OFF,
        ON,
        POWER;

    }
}

