/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.agent.command;

import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.gconsole.agent.command.CommandCode;
import org.lsst.ccs.gconsole.agent.command.CommandTask;

public interface CommandHandle {
    public static final CommandHandle NONE = new CommandHandle(){};

    default public void onSendingFailure(Throwable exception, CommandTask source) {
        this.onResult(CommandCode.SEND_FAIL, exception, source);
    }

    default public void onAck(CommandAck ack, CommandTask source) {
    }

    default public void onNack(CommandNack nack, CommandTask source) {
        this.onResult(CommandCode.NACK, nack, source);
    }

    default public void onSuccess(Object result, CommandTask source) {
        this.onResult(CommandCode.SUCCESS, result, source);
    }

    default public void onExecutionFailure(Throwable exception, CommandTask source) {
        this.onResult(CommandCode.EXEC_FAIL, exception, source);
    }

    default public void onTimeout(TimeoutException exception, CommandTask source) {
        this.onResult(CommandCode.TIMEOUT, exception, source);
    }

    default public void onCancel(CancellationException exception, CommandTask source) {
        this.onResult(CommandCode.CANCEL, exception, source);
    }

    @Deprecated
    default public void onResult(Object result, CommandTask source) {
    }

    default public void onResult(CommandCode code, Object result, CommandTask source) {
        this.onResult(result, source);
    }

    default public String shorten(String message) {
        if (message != null && ((String)message).length() > 200) {
            Matcher m = Pattern.compile("\\s[A-Z]").matcher((CharSequence)message);
            int end = m.find(20) ? m.start() : 150;
            message = ((String)message).substring(0, end) + " ...";
        }
        return message;
    }
}

