/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.NumberFormatter;
import org.lsst.ccs.subsystem.power.config.Power;

public class PowerConfigPanel
extends JPanel {
    private final Power[] power;
    private final NumberFormatter fmt7_3 = new NumberFormatter(new DecimalFormat("##0.0##"));
    private final NumberFormatter fmt5 = new NumberFormatter(new DecimalFormat("####0"));
    private final int TF_WIDTH = 60;
    private final JLabel lbHostname = new JLabel("Hostname:");
    private final JTextField tfHostname = new JTextField();
    private final JLabel lbPort = new JLabel("Port:");
    private final JFormattedTextField tfPort = new JFormattedTextField(this.fmt5);
    private final JLabel[] lbChannel;
    private final JLabel lbVoltage = new JLabel("Voltage");
    private final JFormattedTextField[] tfVoltage;
    private final JLabel lbCurrent = new JLabel("Current");
    private final JFormattedTextField[] tfCurrent;
    private final JLabel lbOnDelay = new JLabel("On delay");
    private final JFormattedTextField[] tfOnDelay;
    private final JLabel lbOffDelay = new JLabel("Off delay");
    private final JFormattedTextField[] tfOffDelay;
    private static final long serialVersionUID = 1L;

    public PowerConfigPanel(Power[] pwr) {
        this.power = pwr;
        this.fmt7_3.setValueClass(Double.class);
        this.fmt5.setValueClass(Integer.class);
        int nChan = 0;
        for (Power p : this.power) {
            nChan += p.getChannels().length;
        }
        this.setBorder(BorderFactory.createTitledBorder(""));
        Dimension dh = this.tfHostname.getPreferredSize();
        dh.width = 120;
        this.tfHostname.setPreferredSize(dh);
        this.tfHostname.setMinimumSize(dh);
        Dimension dp = this.tfPort.getPreferredSize();
        dp.width = 50;
        this.tfPort.setPreferredSize(dp);
        this.tfPort.setMinimumSize(dp);
        this.lbChannel = new JLabel[nChan];
        this.tfVoltage = new JFormattedTextField[nChan];
        this.tfCurrent = new JFormattedTextField[nChan];
        this.tfOnDelay = new JFormattedTextField[nChan];
        this.tfOffDelay = new JFormattedTextField[nChan];
        Dimension d = new JFormattedTextField().getPreferredSize();
        d.width = 60;
        for (int j = 0; j < nChan; ++j) {
            this.lbChannel[j] = new JLabel();
            this.tfVoltage[j] = new JFormattedTextField(this.fmt7_3);
            this.tfVoltage[j].setPreferredSize(d);
            this.tfVoltage[j].setMinimumSize(d);
            this.tfCurrent[j] = new JFormattedTextField(this.fmt7_3);
            this.tfCurrent[j].setPreferredSize(d);
            this.tfCurrent[j].setMinimumSize(d);
            this.tfOnDelay[j] = new JFormattedTextField(this.fmt7_3);
            this.tfOnDelay[j].setPreferredSize(d);
            this.tfOnDelay[j].setMinimumSize(d);
            this.tfOffDelay[j] = new JFormattedTextField(this.fmt7_3);
            this.tfOffDelay[j].setPreferredSize(d);
            this.tfOffDelay[j].setMinimumSize(d);
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        JPanel conPanel = new JPanel();
        conPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcC = new GridBagConstraints();
        gbcC.anchor = 17;
        gbcC.insets = new Insets(6, 4, 6, 4);
        gbcC.gridx = 0;
        gbcC.gridy = 0;
        conPanel.add((Component)this.lbHostname, gbcC);
        ++gbcC.gridx;
        conPanel.add((Component)this.tfHostname, gbcC);
        ++gbcC.gridx;
        conPanel.add((Component)this.lbPort, gbcC);
        ++gbcC.gridx;
        conPanel.add((Component)this.tfPort, gbcC);
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 5;
        this.add((Component)conPanel, gbc);
        gbc.anchor = 10;
        gbc.gridwidth = 1;
        gbc.gridx = 1;
        ++gbc.gridy;
        this.add((Component)this.lbVoltage, gbc);
        ++gbc.gridx;
        this.add((Component)this.lbCurrent, gbc);
        ++gbc.gridx;
        this.add((Component)this.lbOnDelay, gbc);
        ++gbc.gridx;
        this.add((Component)this.lbOffDelay, gbc);
        for (int j = 0; j < nChan; ++j) {
            gbc.anchor = 13;
            gbc.gridx = 0;
            ++gbc.gridy;
            this.add((Component)this.lbChannel[j], gbc);
            gbc.anchor = 10;
            ++gbc.gridx;
            this.add((Component)this.tfVoltage[j], gbc);
            ++gbc.gridx;
            this.add((Component)this.tfCurrent[j], gbc);
            ++gbc.gridx;
            this.add((Component)this.tfOnDelay[j], gbc);
            ++gbc.gridx;
            this.add((Component)this.tfOffDelay[j], gbc);
        }
        this.read();
    }

    private void save() {
        int jc = 0;
        for (Power p : this.power) {
            for (Power.Channel chan : p.getChannels()) {
                chan.setVoltage(((Double)this.tfVoltage[jc].getValue()).doubleValue());
                chan.setCurrent(((Double)this.tfCurrent[jc].getValue()).doubleValue());
                chan.setOnDelay(((Double)this.tfOnDelay[jc].getValue()).doubleValue());
                chan.setOffDelay(((Double)this.tfOffDelay[jc].getValue()).doubleValue());
                ++jc;
            }
        }
    }

    private void read() {
        int jc = 0;
        for (Power p : this.power) {
            for (Power.Channel chan : p.getChannels()) {
                this.lbChannel[jc].setText(chan.getName() + ":");
                this.tfVoltage[jc].setValue(chan.getVoltage());
                this.tfCurrent[jc].setValue(chan.getCurrent());
                this.tfOnDelay[jc].setValue(chan.getOnDelay());
                this.tfOffDelay[jc].setValue(chan.getOffDelay());
                ++jc;
            }
        }
    }

    public static boolean edit(Window parent, Power[] power) {
        final boolean[] changed = new boolean[]{false};
        final JDialog dlg = new JDialog(parent, "Power Configuration", Dialog.ModalityType.APPLICATION_MODAL);
        final PowerConfigPanel p = new PowerConfigPanel(power);
        dlg.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 10, 10, 10);
        dlg.add((Component)p, gbc);
        JPanel btPanel = new JPanel();
        JButton btCancel = new JButton("Cancel");
        btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dlg.setVisible(false);
                dlg.dispose();
            }
        });
        JButton btOK = new JButton("OK");
        btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                changed[0] = true;
                p.save();
                dlg.setVisible(false);
                dlg.dispose();
            }
        });
        btPanel.setLayout(new GridBagLayout());
        gbc.anchor = 11;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        btPanel.add((Component)btCancel, gbc);
        gbc.gridx = 1;
        btPanel.add((Component)btOK, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 11;
        dlg.add((Component)btPanel, gbc);
        dlg.pack();
        dlg.setLocationRelativeTo(parent);
        dlg.setVisible(true);
        return changed[0];
    }
}

