package org.lsst.ccs.subsystem.power.ui.jas;

import java.util.*;
import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.subsystem.common.focalplane.data.HasFocalPlaneData;
import org.lsst.ccs.subsystem.power.ui.RebPowerControlPanel;

/**
 *
 * @author The LSST CCS Team
 */
@Plugin(name = "Reb Power Control plugin", description = "Displays Reb power state including HV bias and DPhi")
public class RebPowerControlPlugin extends ConsolePlugin {

    private final OptionalPage apcpduOptionalPage = new RebPowerControlPlugin.RebPowerControlOptionalPage();

    @Override
    public void initialize() {
//        Console.getConsole().getOptionalPageService().add(apcpduOptionalPage);
        OptionalPage.getService().add(new RebPowerControlPanel.OptPage());
    }

    static class RebPowerControlOptionalPage implements OptionalPage {

        private HashMap<String,MonitorView> views = new HashMap<>();
        
        @Override
        public boolean isAutoOpen() {
            return false;
        }

        @Override
        public String getPage(AgentInfo agent) {
            if ( agent.getAgentProperty(AgentCategory.AGENT_CATEGORY_PROPERTY,"").equals(AgentCategory.POWER.name()) 
                    && !agent.getAgentProperty(HasFocalPlaneData.AGENT_PROPERTY,"").isEmpty() ) {
                return "CCS Subsystems/"+agent.getName() +"/Reb Power Control";
            }
            return null;
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            MonitorView view = new SectionedTableView();
            view.setFormatter(RebPowerStateFilter.FORMAT);
            RebPowerStateFilter filter = new RebPowerStateFilter(agent);
            view.setFilter(filter);
            view.setName(agent.getName() +":RebPowerControl");
            views.put(getPage(agent), view);
            return view.getPanel();
        }

        @Override
        public void opened(String page) {
            MonitorView view = views.get(page);
            if (view != null) {
                view.install();
            }
        }

        @Override
        public void closed(String page) {
            MonitorView view = views.remove(page);
            if (view != null) {
                view.uninstall();
            }
        }

    }
}
