/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui.jas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.subsystem.power.ui.jas.RebPowerStateFormatter;

public class RebPowerStateFilter
extends AbstractChannelsFilter {
    public static final MonitorFormat FORMAT = new RebPowerStateFormatter();
    private final String agent;

    public RebPowerStateFilter(String agent, String pdus) {
        this.agent = agent;
    }

    public RebPowerStateFilter(AgentInfo agent) {
        this.agent = agent.getName();
    }

    public String getName() {
        return this.agent;
    }

    public List<String> getAgents() {
        return Collections.singletonList(this.agent);
    }

    public List<String> getOriginChannels() {
        ArrayList<String> selectors = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                selectors.add("/state/R" + i + j + "/");
            }
        }
        return selectors;
    }

    public String getOriginPath(String displayPath) {
        return super.getOriginPath(displayPath);
    }

    public String getDisplayPath(String originPath) {
        String dp = originPath.replaceFirst(this.agent + "/", "");
        dp = dp.replaceFirst("state/", "");
        return dp;
    }

    public List<String> getFields(boolean compact) {
        return Arrays.asList(MonitorField.VALUE.getKey(), MonitorField.DESCR.getKey());
    }
}

