/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.test.TestingPanel;

public class TestShapes
extends TestingPanel {
    static final int maxCharHeight = 15;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    static final Color red = Color.red;
    static final Color white = Color.white;
    Dimension totalSize;

    public TestShapes(String[] args) throws Exception {
        super(args);
        this.setName("Shapes");
        this.setBackground(bg);
        this.setForeground(fg);
    }

    @Override
    public void paintComponent(Graphics g) {
        VectorGraphics vg = VectorGraphics.create((Graphics)g);
        if (vg != null) {
            this.drawComponent(vg);
        }
    }

    protected void drawComponent(VectorGraphics g) {
        Dimension d = this.getSize();
        g.setColor(bg);
        g.fillRect(0, 0, d.width, d.height);
        int gridWidth = d.width / 6;
        int gridHeight = d.height / 8;
        int x = 5;
        int y = 7;
        int rectWidth = gridWidth - 2 * x;
        int rectHeight = gridHeight - 2 * y;
        this.drawShapes(g, x, y, rectWidth, rectHeight, gridWidth);
        x = 5;
        this.drawFilledShapes(g, x, y += gridHeight, rectWidth, rectHeight, gridWidth);
        x = 5;
        g.setLineWidth(5.0);
        this.drawShapes(g, x, y += gridHeight, rectWidth, rectHeight, gridWidth);
        x = 5;
        this.drawFilledShapes(g, x, y += gridHeight, rectWidth, rectHeight, gridWidth);
        x = 5;
        int xp = x;
        int yp = y += gridHeight;
        String saying = "The quick brown fox jumped over the lazy dog.";
        Font thisFont = new Font("SansSerif", 0, 14);
        g.setFont(thisFont);
        g.drawString("SansSerif: " + saying, xp, yp);
        thisFont = new Font("SansSerif", 1, 14);
        g.setFont(thisFont);
        g.drawString("SansSerif (bold): " + saying, xp, yp += 16);
        thisFont = new Font("SansSerif", 2, 14);
        g.setFont(thisFont);
        g.drawString("SansSerif (italic): " + saying, xp, yp += 16);
        thisFont = new Font("Serif", 0, 14);
        g.setFont(thisFont);
        g.drawString("Serif: " + saying, xp, yp += 16);
        thisFont = new Font("Serif", 1, 14);
        g.setFont(thisFont);
        g.drawString("Serif (bold): " + saying, xp, yp += 16);
        thisFont = new Font("Serif", 2, 14);
        g.setFont(thisFont);
        g.drawString("Serif (italic): " + saying, xp, yp += 16);
        thisFont = new Font("Monospaced", 0, 14);
        g.setFont(thisFont);
        g.drawString("Monospaced: " + saying, xp, yp += 16);
        thisFont = new Font("Monospaced", 1, 14);
        g.setFont(thisFont);
        g.drawString("Monospaced (bold): " + saying, xp, yp += 16);
        thisFont = new Font("Monospaced", 2, 14);
        g.setFont(thisFont);
        g.drawString("Monospaced (italic): " + saying, xp, yp += 16);
        thisFont = new Font("Symbol", 0, 14);
        g.setFont(thisFont);
        g.drawString("Symbol: " + saying, xp, yp += 16);
        thisFont = new Font("Symbol", 1, 14);
        g.setFont(thisFont);
        g.drawString("Symbol (bold): " + saying, xp, yp += 16);
        thisFont = new Font("Symbol", 2, 14);
        g.setFont(thisFont);
        g.drawString("Symbol (italic): " + saying, xp, yp += 16);
        thisFont = new Font("ZapfDingbats", 0, 14);
        g.setFont(thisFont);
        g.drawString("ZapfDingbats: " + saying, xp, yp += 16);
        thisFont = new Font("ZapfDingbats", 1, 14);
        g.setFont(thisFont);
        g.drawString("ZapfDingbats (bold): " + saying, xp, yp += 16);
        thisFont = new Font("ZapfDingbats", 2, 14);
        g.setFont(thisFont);
        g.drawString("ZapfDingbats (italic): " + saying, xp, yp += 16);
        thisFont = new Font("Monospaced", 0, 14);
        g.setFont(thisFont);
        g.drawString("Unbalanced (( )) ))) ((( TEST! )T( (T)", xp, yp += 16);
        yp += 16;
    }

    private void drawShapes(VectorGraphics g, int x, int y, int rectWidth, int rectHeight, int gridWidth) {
        g.setColor(Color.red);
        g.drawLine(x, y + rectHeight - 1, x + rectWidth, y);
        g.setColor(Color.green);
        g.drawRect(x += gridWidth, y, rectWidth, rectHeight);
        g.setColor(Color.blue);
        g.drawRoundRect(x += gridWidth, y, rectWidth, rectHeight, 50, 50);
        g.setColor(Color.cyan);
        g.drawArc(x += gridWidth, y, rectWidth, rectHeight, 90, 135);
        g.setColor(Color.magenta);
        g.drawOval(x += gridWidth, y, rectWidth, rectHeight);
        int[] x1Points = new int[]{x += gridWidth, x + rectWidth, x, x + rectWidth};
        int[] y1Points = new int[]{y, y + rectHeight, y + rectHeight, y};
        g.setColor(Color.yellow);
        g.drawPolygon(x1Points, y1Points, 4);
    }

    private void drawFilledShapes(VectorGraphics g, int x, int y, int rectWidth, int rectHeight, int gridWidth) {
        int[] x2Points = new int[]{x, x + rectWidth, x, x + rectWidth};
        int[] y2Points = new int[]{y, y + rectHeight, y + rectHeight, y};
        g.setColor(Color.red);
        g.drawPolyline(x2Points, y2Points, 4);
        g.setColor(Color.green);
        g.fillRect(x += gridWidth, y, rectWidth, rectHeight);
        g.setColor(fg);
        g.drawRect(x, y, rectWidth, rectHeight);
        g.setColor(Color.blue);
        g.fillRoundRect(x += gridWidth, y, rectWidth, rectHeight, 50, 50);
        g.setColor(fg);
        g.setColor(Color.cyan);
        g.fillArc(x += gridWidth, y, rectWidth, rectHeight, 90, 135);
        g.setColor(fg);
        g.setColor(Color.magenta);
        g.fillOval(x += gridWidth, y, rectWidth, rectHeight);
        g.setColor(fg);
        int[] x3Points = new int[]{x += gridWidth, x + rectWidth, x, x + rectWidth};
        int[] y3Points = new int[]{y, y + rectHeight, y + rectHeight, y};
        g.setColor(Color.yellow);
        g.fillPolygon(x3Points, y3Points, 4);
        g.setColor(fg);
        g.drawPolygon(x3Points, y3Points, 4);
    }

    public static void main(String[] args) throws Exception {
        new TestShapes(args).runTest();
    }
}

